/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


namespace Ocrad
  {
  void internal_error( const char * msg ) throw() __attribute__ ((noreturn));
  bool similar( int a, int b, int percent_dif, int abs_dif = 1 ) throw();
  }


class Charset
  {
  int _charset;
public:
  enum Value { ascii = 1, iso_8859_9 = 2, iso_8859_15 = 4 };

  Charset() throw() : _charset( 0 ) {}
  bool enable( const char * name ) throw();
  bool enabled( Value cset ) const throw();
  bool only( Value cset ) const throw();
  void show_error( const char * arg ) const throw();
  };


struct Control
  {
  enum Format { byte, utf8 };

  FILE *outfile, *exportfile;
  Format format;
  int rindex, debug_level, layout_level, scale, threshold;
  char filetype, specialtype;
  bool append, copy, force, invert, level, verbose;

  Control() throw()
    : outfile( stdout ), exportfile( 0 ),
      format( byte ),
      rindex( -1 ), debug_level( 0 ), layout_level( 0 ),
      scale( 0 ), threshold( -1 ),
      filetype( 0 ), specialtype( 0 ),
      append( false ), copy( false ), force( false ), invert( false ),
      level( false ), verbose( false )
    {}
  bool set_format( const char * name ) throw();
  };
