/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Textblock
  {
  mutable std::vector< Textline > data;

public:
  Textblock( const std::vector< Block > & block_vector ) throw();

  int alnum_percent() const throw();
  void add_line() throw() { data.push_back( Textline() ); }
  void insert_line( int ) throw();
  void delete_line( int ) throw();
  Textline & line( int ) const throw();
  int lines() const throw() { return data.size(); }
  int characters() const throw();

  void print( FILE * outfile, bool graph, bool recursive ) const throw();
  void xprint( FILE * exportfile ) const throw();

  void recognize1() const throw()
    { for( int i = 0; i < lines(); ++i ) line( i ).recognize1(); }
  void recognize2() const throw()
    { for( int i = 0; i < lines(); ++i ) line( i ).recognize2(); }
  };
