/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Textline
  {
  mutable std::vector< Character > data;

public:
  Textline() throw() {}

  void add_character( const Character & c ) throw();
  void insert_character( int i, const Character & ) throw();
  void delete_character( int i ) throw();
  void swap_characters( int i, int j ) throw();
  Character & character( int i ) const throw();
  int characters() const throw() { return data.size(); }

  int mean_height() const throw();
  int mean_width() const throw();
  int mean_gap_width() const throw();
  int mean_hcenter() const throw();
  int mean_vcenter() const throw();

  void join( Textline & l ) throw();
  void print( FILE * outfile, bool graph, bool recursive ) const throw();
  void recognize1() const throw();
  void recognize2() throw();
  };
