/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Features
  {
  const Block * _block;		// Block to witch this features belong
  const Blockmap * _blockmap;	// Blockmap to which the block belongs
  mutable int _hbars, _vbars;
  mutable bool hscan_valid, vscan_valid;
  mutable std::vector< Rectangle > _hbar, _vbar;
  mutable std::vector< int > _hscan, _vscan;

public:
  mutable Profile lp, tp, rp, bp, hp, wp, zhp, zwp;

  Features( const Block & b ) throw();

  const Block * block() const throw() { return _block; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  const Rectangle & hbar( int i ) const throw() { return _hbar[i]; }
  const Rectangle & vbar( int i ) const throw() { return _vbar[i]; }
  int hbars() const throw();
  int vbars() const throw();

  const std::vector< int > & hscan() const throw();
  const std::vector< int > & vscan() const throw();

  unsigned char test_235Esz() const throw();
  unsigned char test_49egpq() const throw();
  unsigned char test_6abd() const throw();
  unsigned char test_CEFIJLlT() const throw();
  unsigned char test_cG() const throw();
  unsigned char test_frt() const throw();
  unsigned char test_HKMNUuvwYy() const throw();
  unsigned char test_hnw() const throw();

  bool test_comma() const throw();
  unsigned char test_line() const throw();
  unsigned char test_solid() const throw();
  unsigned char test_misc() const throw();
  };
