/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

// Only "P1" (pbm) and "P4" (pbm RAWBITS) file formats are recognized.

class Bitmap
  {
  int _width;
  int _height;
  std::vector< std::vector< bool > > data;
  std::vector< Rectangle > _rectangle_list;
public:
  struct Error
    {
    const char * s;
    Error( const char * p ) { s = p; }
    };

  enum type { vertical_histogram, horizontal_histogram, connected_ground };

  Bitmap( FILE * ) throw( Error );	// Creates a Bitmap from a pbm file
  // Creates a Bitmap from another Bitmap
  Bitmap( const Bitmap & source, const Rectangle & r ) throw();
  // Creates a reduced bitmap
  Bitmap( const Bitmap & source, int th, int scale ) throw();
  // Creates a "special" type of Bitmap
  Bitmap( const Bitmap &, type ) throw( Error );

  int width()  const throw() { return _width;  }
  int height() const throw() { return _height; }
  bool get_bit( int row, int col ) const throw() { return data[row][col]; }

  const std::vector< Rectangle > & rectangle_list() const throw()
    { return _rectangle_list; }
  int find_columns( bool verbose = false ) throw();
  int horizontalify( bool verbose = false ) throw();
  void save( FILE *, char filetype = '4' ) const throw();

  friend void floodfill4( const Bitmap & source, Bitmap & dest, int row,
                                                 int col ) throw();
  };
