/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004, 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class Bitmap;

class Blockmap
  {
public:
  struct Zone
    {
    Rectangle rectangle;
    std::vector< std::vector< Block > > block_matrix;
    Zone( const Rectangle & r ) : rectangle( r ) {}
    };

private:
  int _height;
  int _width;
  std::vector< std::vector< int > > data;
  std::vector< Zone > _zone_vector;

  int generate_black_id();
  int generate_white_id();

public:
  Blockmap( const Bitmap & source, int debug_level ) throw();

  int height() const throw() { return _height; }
  int width()  const throw() { return _width;  }
  int id( int row, int col ) const throw() { return data[row][col]; }
  const std::vector< std::vector< int > > & data_matrix() const throw() { return data; }

  int zones() const throw() { return _zone_vector.size(); }
  const std::vector< Zone > & zone_vector() const throw() { return _zone_vector; }
  int blocks_in_map() const throw();
  int blocks_in_zone( int zindex ) const throw();
  int blocks_in_cut( int zindex, int cut ) const throw()
    { return _zone_vector[zindex].block_matrix[cut].size(); }

  void print( FILE * outfile, int debug_level ) const throw();
  };
