/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Textpage
  {
  mutable std::vector< Textline > data;

public:
  Textpage( const Blockmap & blockmap ) throw();

  void add_line() throw() { data.push_back( Textline() ); }
  void insert_line( const int ) throw( Internal_error );
  void delete_line( const int ) throw( Internal_error );
  Textline & line( const int ) const throw( Internal_error );

  int lines() const throw() { return data.size(); }
  void print( FILE * outfile, const bool graph, const bool recursive ) const throw();
  void recognize1() const throw()
    { for( int i = 0; i < lines(); ++i ) line( i ).recognize1(); }
  void recognize2() const throw()
    { for( int i = 0; i < lines(); ++i ) line( i ).recognize2(); }
  };
