/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <cstddef>
#include "common.h"
#include "rectangle.h"


Rectangle::Rectangle( const int l, const int t,	const int r, const int b )
                                                   throw( Internal_error )
  {
  if( r < l || b < t )
    throw Internal_error( "bad parameter building a Rectangle.\n" );
  _left = l; _top = t; _right = r; _bottom = b;
  }

void Rectangle::left( const int l ) throw( Internal_error )
  {
  if( l > _right )
    throw Internal_error( "bad parameter resizing a Rectangle.\n" );
  _left = l;
  }

void Rectangle::top( const int t ) throw( Internal_error )
  {
  if( t > _bottom )
    throw Internal_error( "bad parameter resizing a Rectangle.\n" );
  _top = t;
  }

void Rectangle::right( const int r ) throw( Internal_error )
  {
  if( r < _left )
    throw Internal_error( "bad parameter resizing a Rectangle.\n" );
  _right = r;
  }

void Rectangle::bottom( const int b ) throw( Internal_error )
  {
  if( b < _top )
    throw Internal_error( "bad parameter resizing a Rectangle.\n" );
  _bottom = b;
  }

void Rectangle::add_point( const int row, const int col ) throw()
  {
  if( row > _bottom ) _bottom = row; else if( row < _top ) _top = row;
  if( col > _right ) _right = col;   else if( col < _left ) _left = col;
  }

void Rectangle::add_rectangle( const Rectangle & r ) throw()
  {
  if( r._bottom > _bottom ) _bottom = r._bottom;
  if( r._top < _top ) _top = r._top;
  if( r._right > _right ) _right = r._right;
  if( r._left < _left ) _left = r._left;
  }

bool Rectangle::includes( const Rectangle & r ) const throw()
  {
  return ( _top <= r._top && _bottom >= r._bottom && _left <= r._left &&
           _right >= r._right );
  }

bool Rectangle::includes_hcenter( const Rectangle & r ) const throw()
  { return ( _left <= r.hcenter() && _right >= r.hcenter() ); }

bool Rectangle::includes_vcenter( const Rectangle & r ) const throw()
  { return ( _top <= r.vcenter() && _bottom >= r.vcenter() ); }
