/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <cstdio>
#include <list>
#include <map>
#include <vector>
#include "common.h"
#include "rectangle.h"
#include "block.h"
#include "blockmap.h"
#include "character.h"
#include "textline.h"
#include "textpage.h"
#include "ocr.h"


void print_blocks( const Blockmap & blockmap, FILE * outfile,
						const int debug_level )
  {
  fprintf( outfile, "%d blocks\n", blockmap.block_list().size() );
  fprintf( outfile, "%d %d\n\n", blockmap.width(), blockmap.height() );

  int sp = (debug_level & 1) ? 0 : -1;
  std::list< Block >::const_iterator p = blockmap.block_list().begin();
  for( ; p != blockmap.block_list().end(); ++p )
    p->print( outfile, sp );
  }


void ocr( const Blockmap & blockmap, FILE * outfile, const int debug_level )
  {
  if( debug_level >= 90 )
    { print_blocks( blockmap, outfile, debug_level ); return; }

  Textpage textpage( blockmap );

  if( debug_level >= 86 )
    {
    bool graph = debug_level >= 88 ? true : false;
    bool recursive = (debug_level & 1) ? true : false;
    textpage.print( outfile, graph, recursive );
    return;
    }

  // First pass. Recognize the easy characters.
  textpage.recognize1();

  // Second pass. Use context to resolve ambiguities.
  textpage.recognize2();

  textpage.print( outfile, false, false );
  }
