/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Character : public Rectangle
  {
  std::list< Block > _block_list; // the blocks forming this Character
  std::map< unsigned char, int > _guess_map; // list of possible char codes
				     // and their confidences (-100 to +100)
  const Blockmap * _blockmap;	// Blockmap to which this character belongs

  void recognize11( int charbox_vcenter ) throw();
    void recognize110( int charbox_vcenter ) throw();
      bool iscomma() const throw();
      bool ist() const throw();
      char solid_type( const Block & ) const throw();
    void recognize111() throw();
    void recognize112() throw();
  void recognize12() throw();
  void recognize13() throw();

public:
  Character( const Block & b ) throw()
    : Rectangle( b ), _blockmap( b.blockmap() )
    { _block_list.push_back( b ); }

  Character( const Rectangle & r, const Blockmap & b ) throw()
    : Rectangle( r ), _blockmap( &b ) {}

  int area() const throw();
  const std::list< Block > & block_list() const throw() { return _block_list; }
  const std::map< unsigned char, int > & guess_map() const throw()
    { return _guess_map; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  void add_guess( const unsigned char ch, int confi ) throw();
  void only_guess( const unsigned char ch, int confi ) throw();
  void join( Character & c ) throw( Internal_error );
  void print( FILE * outfile, const bool graph, const bool recursive )
							const throw();
  void recognize1( int charbox_vcenter ) throw();
  };
