#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -D '## ### $ \s \n' ktest1 ktest2 > ./output/k1vs2.res
$NUMDIFF -D '  ##  ###  $    \s   \n ' -X 4 ktest1 ktest2 > ./output/kX4_1vs2.res
$NUMDIFF -D '1:## ### $ \s \n' -D '2:## ### \xE2\x82\xAC \s \n' ktest1 ktest3 > ./output/k1vs3.res
$NUMDIFF -D '1: ## ### \xE2\x82\xAC \s \n' -D '2: ## ### $ \s \n' ktest3 ktest1 > ./output/k3vs1.res
$NUMDIFF -D '1:   ##  ###  $  \s  \n ' -X 4 ktest1 ktest4 > ./output/k1vs4.res
$NUMDIFF -D '2:##  ###  $  \s   \n'  -X 4 ktest4 ktest1 > ./output/k4vs1.res
$NUMDIFF -D '1:## ### $ \s \n' -D '2:\xC2\xA3 ## ### \xE2\x82\xAC \s \n' -X 1:4 -X 2:1 ktest1 ktest5 > ./output/k1vs5.res
$NUMDIFF -D '2:## ### $ \s \n' ktest1_1 ktest2 > ./output/k1_1vs2.res
$NUMDIFF -D '1:## ### $ \s \n' ktest2 ktest1_1 > ./output/k2vs1_1.res
# Now we run the tests with the filter
$NUMDIFF -D '## ### $ \s \n' -Z 2- -X 1:4 ktest1 ktest2.3 > ./output/k1vs2.3.res
$NUMDIFF -D '1:## ### $ \s \n' -D '2:## ### \xE2\x82\xAC \s \n' -Z 2- -X 1:4 ktest1 ktest3.4 > ./output/k1vs3.4.res
$NUMDIFF -D '1:   ##  ###  $  \s  \n ' -Z 2- -X 4 ktest1 ktest4.5 > ./output/k1vs4.5.res
$NUMDIFF -D ' \xC2\xA3 ## ### \xE2\x82\xAC \s \n' -z 1:3- -z 2:3- ktest5 ktest5.5 > ./output/k5vs5.5.res
$NUMDIFF -c '\xC2\xA3' -D '  ## ### \xE2\x82\xAC \s \n' -z 1:3- -z 2:3- ktest6 ktest6plus > ./output/k6c1.res
$NUMDIFF -c ' \xC2\xA3' -D ' ## ### \xE2\x82\xAC \s \n' -z 1:3- -z 2:3- ktest6 ktest6plus > ./output/k6c2.res
$NUMDIFF -c '\xC2\xA3 ' -D '##  ### \xE2\x82\xAC \s \n' -z 1:3- -z 2:3- ktest6 ktest6plus > ./output/k6c3.res
$NUMDIFF -D '2:## ### $ \s \n' -Z 2- ktest1_1 ktest2.3 > ./output/k1_1vs2.3.res
$NUMDIFF -D '\s \t \n %% ____' -c '2:$' -c '1:\xE2\x82\xAC' -Z 2- ktest7 ktest7.2 > ./output/k7vs7.2.res
$NUMDIFF -D '\s \t \n %% ____' -c '1:$' -c '2:\xE2\x82\xAC' -z -3  ktest7.2 ktest7 > ./output/k7.2vs7.res
$NUMDIFF -D '1:\s \t \n :: ____' -D '2:\s \t \n %% ____' -c '2:$' -c '1:\xE2\x82\xAC' -z 1-3 ktest8 ktest8.2 > ./output/k8vs8.2.res

LIST="k1_1vs2.3.res k1_1vs2.res k1vs2.3.res k1vs2.res k1vs3.4.res k1vs3.res k1vs4.5.res k1vs4.res k1vs5.res k2vs1_1.res k3vs1.res k4vs1.res k5vs5.5.res k6c1.res k6c2.res k6c3.res k7.2vs7.res k7vs7.2.res k8vs8.2.res kX4_1vs2.res"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done
