#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

# $NUMDIFF -s" \t:$" -e d -i j -d , -t . hard1 hard2 > ./output/res1
# Since version 5.0.0-beta4 of numdiff
# it is not anymore admitted that the list
# of field delimiters does not include the newline character
$NUMDIFF -s"\n \t:$" -e d -i j -d , -t . hard1 hard2 > ./output/res2
$NUMDIFF -s"\n \t:$," -e d -i j -d , -t . hard1 hard2 > ./output/res3
$NUMDIFF -s"\n \t:$,." -e d -i j -d , -t . hard1 hard2 > ./output/res4
$NUMDIFF -b -s"\n \t:$,." -e d -i j -d , -t . hard1 hard2 > ./output/res5

# LIST="res1 res2 res3 res4 res5"
# Since version 5.0.0-beta4 of numdiff
# it is not anymore admitted that the list
# of field delimiters does not include the newline character

LIST="res2 res3 res4 res5"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done
