#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF  -r 0           list1 list2 > ./output/Res0_0 
$NUMDIFF  -r 0.2499      list1 list2 > ./output/Res0_0.2499 
$NUMDIFF  -r 2.02e0      list1 list2 > ./output/Res0_2.02 
$NUMDIFF  -F 1 -r 0         list1 list2 > ./output/Res1_0 
$NUMDIFF  -F 1 -r 0.2499    list1 list2 > ./output/Res1_0.2499 
$NUMDIFF  -F 1 -r 0.2499 -P list1 list2 > ./output/Res1_0.2499_P 
$NUMDIFF  -F 1 -r 2.02e0    list1 list2 > ./output/Res1_2.02 
$NUMDIFF  -F 1 -r 2.02e0 -N list1 list2 > ./output/Res1_2.02_N 
$NUMDIFF  -F 2 -r 0         list1 list2 > ./output/Res2_0 
$NUMDIFF  -F 2 -r 0.2499    list1 list2 > ./output/Res2_0.2499 
$NUMDIFF  -F 2 -r 0.2499 -P list1 list2 > ./output/Res2_0.2499_P 
$NUMDIFF  -F 2 -r 2.02e0    list1 list2 > ./output/Res2_2.02 
$NUMDIFF  -F 2 -r 2.02e0 -N list1 list2 > ./output/Res2_2.02_N

LIST="Res0_0 Res0_0.2499 Res0_2.02 Res1_0 Res1_0.2499 Res1_0.2499_P Res1_2.02 Res1_2.02_N Res2_0 Res2_0.2499 Res2_0.2499_P Res2_2.02 Res2_2.02_N"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done
