#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -s"\n\t $" -p P+ -n N- -t_.    -d., -o  ./output/res1 -l ./output/warn1 currency1 currency2
$NUMDIFF -s"\n\t _$" -p P+ -n N- -t_.	 -d., -o  ./output/res2 -l ./output/warn2 currency1 currency2
$NUMDIFF -s"\n\t +-$" -p P+ -n N- -t_.	 -d., -o  ./output/res3 -l ./output/warn3 currency1 currency2
$NUMDIFF -s"\n\t NP$" -p P+ -n N- -t_.	 -d., -o  ./output/res4 -l ./output/warn4 currency1 currency2
$NUMDIFF -s"\n\t NP+-$" -p P+ -n N- -t_. -d., -o ./output/res5 -l ./output/warn5 currency1 currency2

LIST="res1 res2 res3 res4 res5"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

