#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3
NDSELECT=$4

$NDSELECT --delimiters='\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' --beginning=4 --end=15 --step=3 --first-field=2 --last-field=8 --increment=2 --output-separator='\t' ndselect_test > ./output/b4e15s3F2L8I2Otab.res

$NDSELECT --delimiters='\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' --omit-empty-lines --first-field=4 --increment=3 --beginning=6 --step=2 --output-separator='\t' ndselect_test > ./output/xF4I3b6s2Otab.res

$NDSELECT --separators=' \t\n$\"!|:#' --end=18 --last-field=7 --increment=4 --output-separator='\t:\t' --output=./output/e18L7I4O.res  ndselect_test 

$NDSELECT -l ./output/stderr1.res -w

$NDSELECT --warnings-to=./output/stderr2.res -w

$NUMDIFF --formula=0 list1 list2 > ./output/fmla0.res

$NUMDIFF --formula=1 list1 list2 > ./output/fmla1.res

$NUMDIFF --formula=2 --output=./output/fmla2.res list1 list2 

$NUMDIFF --warnings-to=./output/warning.res --formula=3 list1 list2

$NUMDIFF -z 2 -S --currency='$'  --delimiters='%%% \r \n' --binary --overview two_columns1 two_columns2 > ./output/overview.res

$NUMDIFF -z 2 -S --currency='$'  --delimiters='%%% \r \n' --binary --overview=60 two_columns1 two_columns2 > ./output/overview60.res

$NDSELECT --delimiters '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' --beginning 4 --end 15 --step 3 --first-field 2 --last-field 8 --increment 2 --output-separator '\t' ndselect_test > ./output/b4e15s3F2L8I2Otab.res2

$NDSELECT --delimiters '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' --omit-empty-lines --first-field 4 --increment 3 --beginning 6 --step 2 --output-separator '\t' ndselect_test > ./output/xF4I3b6s2Otab.res2

$NDSELECT --separators ' \t\n$\"!|:#' --end 18 --last-field 7 --increment 4 --output-separator '\t:\t' --output ./output/e18L7I4O.res2  ndselect_test 

$NDSELECT -l ./output/stderr1.res2 -w

$NDSELECT --warnings-to ./output/stderr2.res2 -w

$NUMDIFF --formula 0 list1 list2 > ./output/fmla0.res2

$NUMDIFF --formula 1 list1 list2 > ./output/fmla1.res2

$NUMDIFF --formula 2 --output ./output/fmla2.res2 list1 list2 

$NUMDIFF --warnings-to ./output/warning.res2 --formula 3 list1 list2

$NUMDIFF -z 2 -S --currency '$'  --delimiters '%%% \r \n' --binary --overview two_columns1 two_columns2 > ./output/overview.res2

LIST="b4e15s3F2L8I2Otab.res xF4I3b6s2Otab.res e18L7I4O.res stderr1.res stderr2.res fmla0.res fmla1.res fmla2.res warning.res overview.res overview60.res b4e15s3F2L8I2Otab.res2 e18L7I4O.res2 fmla0.res2 fmla1.res2 fmla2.res2 overview.res2 stderr1.res2 stderr2.res2 warning.res2 xF4I3b6s2Otab.res2"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
