#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2011    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3
NDSELECTX="ndselect -x"
NDSELECT=ndselect

$NDSELECTX -b 2 -b 4 matrix > ./output/xb2b4_matrix
$NDSELECTX -b 4 -b 2 matrix > ./output/xb4b2_matrix
$NDSELECTX -e 7 -e 3 matrix > ./output/xe7e3_matrix
$NDSELECTX -e 3 -e 7 matrix > ./output/xe3e7_matrix
$NDSELECTX -s 2 -s 3 matrix > ./output/xs2s3_matrix
$NDSELECTX -s 3 -s 2 matrix > ./output/xs3s2_matrix
$NDSELECTX -F 4 -F 6 matrix > ./output/xF4F6_matrix
$NDSELECTX -F 6 -F 4 matrix > ./output/xF6F4_matrix
$NDSELECTX -L 1 -L 5 matrix > ./output/xL1L5_matrix
$NDSELECTX -L 5 -L 1 matrix > ./output/xL5L1_matrix
$NDSELECTX -I 2 -I 3 matrix > ./output/xI2I3_matrix
$NDSELECTX -I 3 -I 2 matrix > ./output/xI3I2_matrix
$NDSELECTX many_fields > ./output/xbasic
$NDSELECTX -F 1 many_fields > ./output/xF1_many_fields
$NDSELECTX -F 1 -L 0 many_fields > ./output/xF1_L0_many_fields
$NDSELECTX -F 1 -L 0 -I 1 many_fields > ./output/xF1_L0_I1_many_fields
$NDSELECTX -F 2 many_fields > ./output/xF2_many_fields
$NDSELECTX -F 2 -L 0 many_fields > ./output/xF2_L0_many_fields
$NDSELECTX -F 2 -L 0 -I 1 many_fields > ./output/xF2_L0_I1_many_fields
$NDSELECTX -F 3 many_fields > ./output/xF3_many_fields
$NDSELECTX -F 3 -L 0 many_fields > ./output/xF3_L0_many_fields
$NDSELECTX -F 3 -L 0 -I 1 many_fields > ./output/xF3_L0_I1_many_fields
$NDSELECTX -F 4 many_fields > ./output/xF4_many_fields
$NDSELECTX -F 4 -L 0 many_fields > ./output/xF4_L0_many_fields
$NDSELECTX -F 4 -L 0 -I 1 many_fields > ./output/xF4_L0_I1_many_fields
$NDSELECTX -F 9 many_fields > ./output/xF9_many_fields
$NDSELECTX -F 9 -L 0 many_fields > ./output/xF9_L0_many_fields
$NDSELECTX -F 9 -L 0 -I 1 many_fields > ./output/xF9_L0_I1_many_fields
$NDSELECTX -F 10 many_fields > ./output/xF10_many_fields
$NDSELECTX -F 10 -L 0 many_fields > ./output/xF10_L0_many_fields
$NDSELECTX -F 10 -L 0 -I 1 many_fields > ./output/xF10_L0_I1_many_fields
$NDSELECTX -F 4 -L 8 many_fields > ./output/xF4_L8_many_fields
$NDSELECTX -F 4 -L 8 -I 2 many_fields > ./output/xF4_L8_I2_many_fields
$NDSELECTX -F 4 -L 8 -I 3 many_fields > ./output/xF4_L8_I3_many_fields
$NDSELECTX -F 4 -L 8 -I 4 many_fields > ./output/xF4_L8_I4_many_fields
$NDSELECTX -F 4 -L 8 -I 5 many_fields > ./output/xF4_L8_I5_many_fields
$NDSELECTX -L 8 many_fields > ./output/xL8_many_fields
$NDSELECTX -L 8 -I 2 many_fields > ./output/xL8_I2_many_fields
$NDSELECTX -L 8 -I 3 many_fields > ./output/xL8_I3_many_fields
$NDSELECTX -L 8 -I 5 many_fields > ./output/xL8_I5_many_fields
$NDSELECTX -L 8 -I 8 many_fields > ./output/xL8_I8_many_fields
$NDSELECTX -L 9 -I 4 many_fields > ./output/xL9_I4_many_fields
$NDSELECTX -L 100 -I 4 many_fields > ./output/xL100_I4_many_fields
$NDSELECTX -I 4 many_fields > ./output/xI4_many_fields
$NDSELECTX -I 20 many_fields > ./output/xI20_many_fields
$NDSELECTX file2 > ./output/xout_file2
$NDSELECTX -b 1 file2 > ./output/xb1_out_file2
$NDSELECTX -b 1 -e 0 file2 > ./output/xb1_e0_out_file2
$NDSELECTX -b 1 -e 0 -s 1 file2 > ./output/xb1_e0_s1_out_file2
$NDSELECTX -b 2 file2 > ./output/xb2_out_file2
$NDSELECTX -b 2 -e 0 file2 > ./output/xb2_e0_out_file2
$NDSELECTX -b 2 -e 0 -s 1 file2 > ./output/xb2_e0_s1_out_file2
$NDSELECTX -b 4 file2 > ./output/xb4_out_file2
$NDSELECTX -b 4 -e 0 file2 > ./output/xb4_e0_out_file2
$NDSELECTX -b 4 -e 0 -s 1 file2 > ./output/xb4_e0_s1_out_file2
$NDSELECTX -b 13 file2 > ./output/xb13_out_file2
$NDSELECTX -b 13 -e 0 file2 > ./output/xb13_e0_out_file2
$NDSELECTX -b 13 -e 0 -s 1 file2 > ./output/xb13_e0_s1_out_file2
$NDSELECTX -b 25 file2 > ./output/xb25_out_file2
$NDSELECTX -b 25 -e 0 file2 > ./output/xb25_e0_out_file2
$NDSELECTX -b 25 -e 0 -s 1 file2 > ./output/xb25_e0_s1_out_file2
$NDSELECTX -b 26 file2 > ./output/xb26_out_file2
$NDSELECTX -b 26 -e 0 file2 > ./output/xb26_e0_out_file2
$NDSELECTX -b 26 -e 0 -s 1 file2 > ./output/xb26_e0_s1_out_file2
$NDSELECTX -b 27 file2 > ./output/xb27_out_file2
$NDSELECTX -b 27 -e 0 file2 > ./output/xb27_e0_out_file2
$NDSELECTX -b 27 -e 0 -s 1 file2 > ./output/xb27_e0_s1_out_file2
$NDSELECTX -b 100 file2 > ./output/xb100_out_file2
$NDSELECTX -b 100 -e 0 file2 > ./output/xb100_e0_out_file2
$NDSELECTX -b 100 -e 0 -s 1 file2 > ./output/xb100_e0_s1_out_file2
$NDSELECTX -b 11 -e 3 file2 > ./output/xb11_e3_out_file2
$NDSELECTX -b 11 -e 11 file2 > ./output/xb11_e11_out_file2
$NDSELECTX -b 11 -e 23 file2 > ./output/xb11_e23_out_file2
$NDSELECTX -b 11 -e 23 -s 2 file2 > ./output/xb11_e23_s2_out_file2
$NDSELECTX -b 11 -e 23 -s 3 file2 > ./output/xb11_e23_s3_out_file2
$NDSELECTX -b 11 -e 23 -s 5 file2 > ./output/xb11_e23_s5_out_file2
$NDSELECTX -b 11 -e 23 -s 12 file2 > ./output/xb11_e23_s12_out_file2
$NDSELECTX -b 11 -e 23 -s 13 file2 > ./output/xb11_e23_s13_out_file2
$NDSELECTX -b 11 -e 23 -s 2 -L 8 file2 > ./output/xb11_e23_s2_L8_out_file2
$NDSELECTX -b 11 -e 23 -s 2 -F 2 -L 9 file2 > ./output/xb11_e23_s2_F2_L9_out_file2
$NDSELECTX -b 11 -e 23 -s 3 -F 2 -L 9 file2 > ./output/xb11_e23_s3_F2_L9_out_file2
$NDSELECTX -b 11 -e 23 -s 2 -F 2 -I 2 file2 > ./output/xb11_e23_s2_F2_I2_out_file2
$NDSELECTX -b 11 -e 23 -s 3 -F 2 -I 3 file2 > ./output/xb11_e23_s3_F2_I3_out_file2
$NDSELECTX -b 11 -e 23 -s 2 -L 8 -I 3 file2 > ./output/xb11_e23_s2_L8_I3_out_file2
$NDSELECTX -b 11 -e 23 -s 3 -L 8 -I 4 file2 > ./output/xb11_e23_s3_L8_I4_out_file2
$NDSELECTX -b 11 -e 23 -F 3 -L 9 file2 > ./output/xb11_e23_F3_L9_out_file2
$NDSELECTX -b 11 -e 23 -F 3 -L 9 -I 2 file2 > ./output/xb11_e23_F3_L9_I2_out_file2
$NDSELECTX -b 11 -e 23 -F 3 -L 9 -I 3 file2 > ./output/xb11_e23_F3_L9_I3_out_file2
$NDSELECTX -b 11 -e 23 -F 3 -L 9 -I 4 file2 > ./output/xb11_e23_F3_L9_I4_out_file2
$NDSELECTX -b 11 -e 23 -F 3 -L 3 -I 4 file2 > ./output/xb11_e23_F3_L3_I4_out_file2
$NDSELECTX -b 11 -e 23 -F 4 -L 3 -I 4 file2 > ./output/xb11_e23_F4_L3_I4_out_file2
$NDSELECTX -b 11 -e 23 -F 4 -L 3 file2 > ./output/xb11_e23_F4_L3_out_file2
$NDSELECTX -S ':#\n' file > ./output/xresult
$NDSELECTX -S '-\n' file > ./output/xresult2
$NDSELECTX -S ':#\n' -F 2 -I 2 file > ./output/xF2_I2_result
$NDSELECTX -S '-\n' -F 2 -I 2 file > ./output/xF2_I2_result2
$NDSELECTX -S '-\n' -S ':#\n' -F 2 -I 2 file > ./output/xF2_I2_result_II
$NDSELECTX -S ':#\n' -S '-\n' -F 2 -I 2 file > ./output/xF2_I2_result2_II
$NDSELECTX -S ':#\n' -b 4 -e 10 -L 4 -I 2 file > ./output/xb4_e10_L4_I2_result
$NDSELECTX -S ':#\n' -b 4 -e 10 -s 3 -F 2 -L 4 -I 2 file > ./output/xb4_e10_s3_F2_L4_I2_result
$NDSELECTX -S ':#\n' -b 4 -e 10 -s 4 -F 2 -I 3 file > ./output/xb4_e10_s4_F2_I3_result
$NDSELECTX -S '-\n' -b 4 -e 10 -L 4 -I 2 file > ./output/xb4_e10_L4_I2_result2
$NDSELECTX -S '-\n' -b 4 -e 10 -s 3 -F 2 -L 4 -I 2 file > ./output/xb4_e10_s3_F2_L4_I2_result2
$NDSELECTX -S '-\n' -b 4 -e 10 -s 4 -F 2 -I 3 file > ./output/xb4_e10_s4_F2_I3_result2

$NDSELECT many_fields > ./output/basic
$NDSELECT -S ':#\n' file > ./output/result
$NDSELECT -S '-\n' file > ./output/result2
$NDSELECT -L 8 many_fields > ./output/L8_many_fields
$NDSELECT -L 8 -I 5 many_fields > ./output/L8_I5_many_fields
$NDSELECT -F 1 -L 0 -I 1 many_fields > ./output/F1_L0_I1_many_fields
$NDSELECT -F 4 -L 8 -I 2 many_fields > ./output/F4_L8_I2_many_fields
$NDSELECT -F 4 -L 8 -I 3 many_fields > ./output/F4_L8_I3_many_fields
$NDSELECT -b 11 -e 23 -F 3 -L 3 -I 4 file2 > ./output/b11_e23_F3_L3_I4_out_file2
$NDSELECT -b 11 -e 23 -F 3 -L 9 -I 2 file2 > ./output/b11_e23_F3_L9_I2_out_file2
$NDSELECT -b 11 -e 23 -F 3 -L 9 -I 3 file2 > ./output/b11_e23_F3_L9_I3_out_file2
$NDSELECT -b 11 -e 23 -F 3 -L 9 -I 4 file2 > ./output/b11_e23_F3_L9_I4_out_file2
$NDSELECT -b 11 -e 23 -F 3 -L 9 file2 > ./output/b11_e23_F3_L9_out_file2
$NDSELECT -S ':#\n' -b 4 -e 10 -s 4 -F 2 -I 3 file > ./output/b4_e10_s4_F2_I3_result
$NDSELECT -S '-\n' -b 4 -e 10 -s 4 -F 2 -I 3 file > ./output/b4_e10_s4_F2_I3_result2

LIST="xb100_e0_out_file2 xb100_e0_s1_out_file2 xb100_out_file2 xb11_e11_out_file2 xb11_e23_F3_L3_I4_out_file2 xb11_e23_F3_L9_I2_out_file2 xb11_e23_F3_L9_I3_out_file2 xb11_e23_F3_L9_I4_out_file2 xb11_e23_F3_L9_out_file2 xb11_e23_F4_L3_I4_out_file2 xb11_e23_F4_L3_out_file2 xb11_e23_out_file2 xb11_e23_s12_out_file2 xb11_e23_s13_out_file2 xb11_e23_s2_F2_I2_out_file2 xb11_e23_s2_F2_L9_out_file2 xb11_e23_s2_L8_I3_out_file2 xb11_e23_s2_L8_out_file2 xb11_e23_s2_out_file2 xb11_e23_s3_F2_I3_out_file2 xb11_e23_s3_F2_L9_out_file2 xb11_e23_s3_L8_I4_out_file2 xb11_e23_s3_out_file2 xb11_e23_s5_out_file2 xb11_e3_out_file2 xb13_e0_out_file2 xb13_e0_s1_out_file2 xb13_out_file2 xb1_e0_out_file2 xb1_e0_s1_out_file2 xb1_out_file2 xb25_e0_out_file2 xb25_e0_s1_out_file2 xb25_out_file2 xb26_e0_out_file2 xb26_e0_s1_out_file2 xb26_out_file2 xb27_e0_out_file2 xb27_e0_s1_out_file2 xb27_out_file2 xb2b4_matrix xb2_e0_out_file2 xb2_e0_s1_out_file2 xb2_out_file2 xb4b2_matrix xb4_e0_out_file2 xb4_e0_s1_out_file2 xb4_e10_L4_I2_result xb4_e10_L4_I2_result2 xb4_e10_s3_F2_L4_I2_result xb4_e10_s3_F2_L4_I2_result2 xb4_e10_s4_F2_I3_result xb4_e10_s4_F2_I3_result2 xb4_out_file2 xbasic xe3e7_matrix xe7e3_matrix xF10_L0_I1_many_fields xF10_L0_many_fields xF10_many_fields xF1_L0_I1_many_fields xF1_L0_many_fields xF1_many_fields xF2_I2_result xF2_I2_result2 xF2_I2_result2_II xF2_I2_result_II xF2_L0_I1_many_fields xF2_L0_many_fields xF2_many_fields xF3_L0_I1_many_fields xF3_L0_many_fields xF3_many_fields xF4F6_matrix xF4_L0_I1_many_fields xF4_L0_many_fields xF4_L8_I2_many_fields xF4_L8_I3_many_fields xF4_L8_I4_many_fields xF4_L8_I5_many_fields xF4_L8_many_fields xF4_many_fields xF6F4_matrix xF9_L0_I1_many_fields xF9_L0_many_fields xF9_many_fields xI20_many_fields xI2I3_matrix xI3I2_matrix xI4_many_fields xL100_I4_many_fields xL1L5_matrix xL5L1_matrix xL8_I2_many_fields xL8_I3_many_fields xL8_I5_many_fields xL8_I8_many_fields xL8_many_fields xL9_I4_many_fields xout_file2 xresult xresult2 xs2s3_matrix xs3s2_matrix b11_e23_F3_L3_I4_out_file2 b11_e23_F3_L9_I2_out_file2 b11_e23_F3_L9_I3_out_file2 b11_e23_F3_L9_I4_out_file2 b11_e23_F3_L9_out_file2 b4_e10_s4_F2_I3_result b4_e10_s4_F2_I3_result2 basic F1_L0_I1_many_fields F4_L8_I2_many_fields F4_L8_I3_many_fields L8_I5_many_fields L8_many_fields result result2"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
