#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2009    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -Z 1:2 -Z 2:2 -V  Table1 Table2 > ./output/ZVG2
$NUMDIFF -Z 1:2 -Z 2:2 -f  0 Table1 Table2 > ./output/ZfG2
$NUMDIFF -Z 1:2 -Z 2:2 -f  0 -R '.*Random.*' Table1 Table2 > ./output/ZfG2R
$NUMDIFF -Z 1:2 -Z 2:2 -f  0 -R '.*Random.*' -T Table1 Table2 > ./output/ZfG2RT
$NUMDIFF -Z 1:2 -Z 2:2 -f  0 -T Table1 Table2 > ./output/ZfG2T
$NUMDIFF -Z 1:2 -Z 2:2 -f -1 Table1 Table2 > ./output/ZfscG2
$NUMDIFF -Z 1:2 -Z 2:2 -f -1 -R '.*Random.*' Table1 Table2 > ./output/ZfscG2R
$NUMDIFF -Z 1:2 -Z 2:2 -f -1 -R '.*Random.*' -T Table1 Table2 > ./output/ZfscG2RT
$NUMDIFF -Z 1:2 -Z 2:2 -f -1 -T Table1 Table2 > ./output/ZfscG2T
$NUMDIFF -z 1:2 -z 2:2 -f  0 Table1 Table2 > ./output/zfG2
$NUMDIFF -z 1:2 -z 2:2 -f  0 -T Table1 Table2 > ./output/zfG2T
$NUMDIFF -z 1:2 -z 2:2 -f -1 Table1 Table2 > ./output/zfscG2
$NUMDIFF -z 1:2 -z 2:2 -f -1 -T Table1 Table2 > ./output/zfscG2T


LIST="ZVG2 ZfG2 ZfG2R ZfG2RT ZfG2T ZfscG2 ZfscG2R ZfscG2RT ZfscG2T zfG2 zfG2T zfscG2 zfscG2T"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

# Common error message
# ***  End of file "Table1" reached
#      Likely the files "Table1" and "Table2" do not have the same number of lines !
