/*
    Numdiff - compare putatively similar files, 
    ignoring small numeric differences
    Copyright (C) 2005-2007  Ivano Primi  <ivprimi@libero.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _NDFILTER_H_
#define _NDFILTER_H_

#include"config.h"

/* Constants and default values */
#define CHUNK_ALLOC  20480
#define DEF_SYMB_POS 62U
#define TAB_WD       8U

#define SDIFF_CMD   "sdiff "
#define SUFFIX      ".new"
#define EMPTY_LINE  "\n"
#define NEW_LINE    '\n'

/* Error codes */
#define OUT_OF_MEM     -1
#define OPEN_ERR_ORIG1 -2
#define OPEN_ERR_ORIG2 -3
#define OPEN_ERR_NEW1  -4
#define OPEN_ERR_NEW2  -5
#define READ_ERR_ORIG1 -6
#define READ_ERR_ORIG2 -7
#define WRITE_ERR_NEW1 -8
#define WRITE_ERR_NEW2 -9

#define EXEC_ERR      -10
#define FORMAT_ERR    -11

typedef struct {
  unsigned char* ptr;
  size_t len, size;
} flg_array; /* A structure of this type is used to store the information
		retrieved from the execution of a diff command */

typedef struct {
  /* Mask of the options */
  unsigned long optmask;

  /* Command to be executed (default: "sdiff") */
  /* and suffix to add in order to create the  */
  /* names for the new files (default: ".new") */
  const char *command, *suffix;

  /* Tab width (default: 8) and symb_pos (default: 62) */
  unsigned short tab_wd, symb_pos;

  /* Files to handle */
  const char *file1, *file2;
} nargslist ; /* A structure of this type is used to store the options */
/* set by the user                                                     */ 

#define __H_MASK   0x00000001 /* -h option, used to recall help */
#define __S_MASK   0x00000002 /* -s option, used to explicitly set suffix  */
#define __P_MASK   0x00000004 /* -p option, used to set the symbol position */
#define __T_MASK   0x00000008 /* -t option, used to set Tab width */
#define __N_MASK   0x00000010 /* -n option, used to enable printing of 
		  	    	line numbers */
#define __E_MASK   0x00000020 /* -e option, used to set the diff command */
#define __D_MASK   0x00000040 /* -d option, used to enable printing of
				debug info   */
#define __V_MASK   0x00000080 /* -v option, used to show version number,
			        Copyright and No-Warranty */

/* I18N and L10N support */

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)
#else
#define _(String) (String)
#define N_(String) String
#define textdomain(Domain)
#define bindtextdomain(Package, Directory)
#endif

#ifndef PACKAGE2
#define PACKAGE2 "ndfilter"
#endif

#ifndef LOCALEDIR
#define LOCALEDIR "/usr/local/share/locale/"
#endif

#endif /* _NDFILTER_H_ */
