<?php

/************************************************************************/
/* PHP-NUKE: LDAP Management                                            */
/* =========================                                            */
/*                                                                      */
/* Copyright (c) 2005 by William Wong                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

define('_LDAP_VERSION_INFO',"NukeLDAP Version 2.1.0 beta");
define('_LDAP_COPYRIGHT_INFO',"Copyright (c) 2005 William Wong");
define('_LDAP_WEB_INFO',"<a href=\"http://savannah.nongnu.org/projects/nukeldap/\">NukeLDAP Project</a>");

if (!defined('ADMIN_FILE')) {
	die ("Access Denied");
}

global $prefix, $db, $admin_file;
$aid = substr("$aid", 0,25);
$row = $db->sql_fetchrow($db->sql_query("SELECT radminsuper FROM " . $prefix . "_authors WHERE aid='$aid'"));
if ($row['radminsuper'] == 1) {

	include("admin/language/ldap-lang-".$language.".php"); // load our language file

	/*********************************************************/
	/* Users Groups Functions                                */
	/*********************************************************/
	define('NO_EDITOR', 1);

	function ldap_config_row($c1="&nbsp",$c2="&nbsp",$c3="") {
		echo "<tr><td valign=top>$c1</td>";
		echo ($c3=="")?"<td colspan=2>$c2</td></tr>":"<td>$c2</td><td>$c3</td></tr>";
	}

	function ldap_config_field($pre,$field,$req=0){
		ldap_config_row($pre,$field,$req?_LDAP_REQUIRED:"");
	}

        function ldap_config_text($ldap,$pre,$var,$req=0,$size=40){
		ldap_config_field($pre,"<input type=text name=ldap$var size=$size value=\"".$ldap[$var]."\">",$req);
        }

	function ldap_config_check($ldap,$pre,$var,$suf="",$req=0){
		ldap_config_field($pre,"<input type=checkbox name=ldap$var ".($ldap[$var]?"CHECKED":"").">".$suf,$req);
	}

	function ldap_config_submit($title,$name){
		ldap_config_field("","<input type=submit name=ldap$name value=\"$title\">");
	}


	function ldap_config_area($ldap,$pre,$var,$req=0,$rows=4,$cols=40){
		$field="<textarea name=ldap$var rows=$rows cols=$cols>\n";
		foreach ($ldap[$var] as $v)
			$field.=$v."\n";
		ldap_config_field($pre,$field.'</textarea>',$reg);
	}		

	function ldap_config_title($title,$blank=1,$c2="",$c3=""){
		if ($blank)
			ldap_config_row();
		ldap_config_row("<b>$title</b>",$c2,$c3);
	}

	function ldap_config($msg="") {
		global $admin_file;

		$ldap = ldap_get_variables();

		include("header.php");
		// GraphicAdmin();

		title("<center><a href=\"admin.php\">"._ADMINMENU."</a></center>");

		title(_LDAP_CONFIGURATION);

		OpenTable();

		echo "<form name=ldap action=\"".$admin_file.".php\" \" method=\"post\">"
		    ."<input type=\"hidden\" name=\"op\" value=\"ldap\">";
		echo "<table>";

		if ($msg!=""){
			ldap_config_row("<b>Status:</b>","<b>$msg</b>");
			ldap_config_row();
		}


		ldap_config_title(_LDAP_System_Settings,0);
		ldap_config_check($ldap,_LDAP_Enable,'enable');	
		ldap_config_text($ldap,'LDAP '._LDAP_host,'host',1);
		ldap_config_text($ldap,'LDAP '._LDAP_port,'port',1,10);
		ldap_config_text($ldap,'LDAP '._LDAP_version,'version',0,10);
		ldap_config_text($ldap,'Bind DN','binddn',1);
		ldap_config_text($ldap,'LDAP '._LDAP_password,'password',1);
		ldap_config_text($ldap,'LDAP '._LDAP_base,'base',1);
		ldap_config_text($ldap,'LDAP ID','ldapID',1);	

		ldap_config_text($ldap,'LDAP Password','ldapPassword',1);
		ldap_config_submit(_LDAP_Save,'save');
		ldap_config_submit(_LDAP_Test_connection,'connect');

		ldap_config_title('LDAP '._LDAP_Users);
		ldap_config_check($ldap,_LDAP_Local_users,'useNuke',_LDAP_Local_users_note);
		ldap_config_row();
		ldap_config_check($ldap,_LDAP_No_Add,'noAdd',_LDAP_No_Add_note);
		ldap_config_check($ldap,_LDAP_No_Del,'noDel',_LDAP_No_Del_note);
		ldap_config_check($ldap,_LDAP_No_Mod,'noMod',_LDAP_No_Mod_note);
		ldap_config_row();
		ldap_config_title(_LDAP_Add_User,1,_LDAP_Add_User_note);
		ldap_config_area($ldap,'Objectclass','objectclass');
		ldap_config_row();
		ldap_config_area($ldap,_LDAP_Fields,'default',1);
		ldap_config_row("",_LDAP_Field_Syntax);
		ldap_config_row("",_LDAP_Use_Name);
		ldap_config_submit(_LDAP_Save,'save');
		ldap_config_row();
		ldap_config_text(array('testname' => 'tester'),'Test name','testname');
		ldap_config_submit(_LDAP_Test_user,'user');

		ldap_config_title('Scripts');
		ldap_config_text($ldap,_LDAP_Execute,'exec',0,60);
		ldap_config_text($ldap,_LDAP_Add.' '._LDAP_script,'addscript',0,60);
		ldap_config_text($ldap,_LDAP_Delete.' '._LDAP_script,'delscript',0,60);
		ldap_config_text($ldap,_LDAP_Change.' '._LDAP_script,'modscript',0,60);

		ldap_config_submit(_LDAP_Save,'save');

		echo "</table>";
		echo "</form>";
		CloseTable();

		echo "<br>";

		OpenTable();
		echo "<center><b>"._LDAP_VERSION_INFO."</b></center>";
		echo "<center>"._LDAP_COPYRIGHT_INFO."</center>";	
		echo "<center>"._LDAP_WEB_INFO."</center>";
		CloseTable();

		include("footer.php");
	}

	function ldap_no_empty($v){
		return $v!="";
	}

	function ldap_do_save(){
		global $_POST,$ldap_vars,$ldap_var_arrays;
		foreach ($ldap_vars as $name) {
			$result[$name]=$_POST['ldap'.$name];
		}
		foreach ($ldap_var_arrays as $name){
			$result[$name]=array_filter(preg_split("/\r?\n/",$_POST['ldap'.$name]),ldap_no_empty);
		}

		ldap_set_variables($result);
		return $result;
	}

	function ldap_save(){
		ldap_do_save();
		ldap_config("Settings saved");
	}

	function ldap_test_connect(){
		$ldap=ldap_do_save();
		$host=$ldap['host'];
		$msg="Cannot access <i>$host</i>";

		$ds=ldap_do_connect($ldap);
		if($ds){
			if(ldap_do_bind($ds,$ldap)) {
				$msg="Connected to <i>$host</i>";
			} elseif (ldap_bind($ds)) {
				$msg="Connected anonymously to <br><i>$host</i>.<br>Check Bind DN and password.";
			}
			ldap_close($ds);
		}
		ldap_config($msg);
	}

	function ldap_test_user(){
		global $_POST;
		$msg="Cannot create user";
		$ldap=ldap_do_save();
		$name=$_POST['ldaptestname'];
		$password="asdf1234";

		if (ldap_check_user($ldap,$name)){
			$msg="User already exists.";
		} elseif (ldap_create_user($ldap,$name,$password)){
			if(ldap_delete_user($ldap,$name)) {
				$msg="Create and delete succeeded";
			} else {
				$msg="Create succeeded. Delete failed.";
			}
		}

		ldap_config($msg);
	}

	function ldap_submitted($name){
		global $_POST;
		return isset($_POST[$name]);
	}


	switch ($op) {
		case 'ldap':
			if (ldap_submitted('ldapsave')) {
				ldap_save();
			}	
			elseif (ldap_submitted('ldapconnect')) {
				ldap_test_connect();
			}
			elseif (ldap_submitted('ldapuser')) {
				ldap_test_user();
			}
			else {
				ldap_config($msg);
			}
			break;
	}

die($op);
} else {
	echo "Access Denied";
}

?>
