<?php
/***************************************************************************
 *                            synch-ldap-samba.php
 *                            -------------------
 *   begin                : December 10, 2004
 *   copyright            : (C) 2004 William Wong
 *   email                : bwong at voicenet.com
 *
 *   $Id: synch-ldap-posix.php,v 2.00 2004/12/10 $
 *
 ***************************************************************************/
/*                                                                      */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */
/*                                                                         */
/***************************************************************************/

if (eregi("synch-ldap-samba.php",$_SERVER['PHP_SELF'])) {
    Header("Location: ../index.php");
    die();
}

// NOTE: assumes samba user is also a posix user, if not {uidnumber} and {gidnumber} will not be set
//
// global parameters
synchSet('sambaEnabled',"1");
synchSet('defaultSambaLogonScript',"\\\\server\\netlogon\\default.bat");
synchSet('sambaGroupRID','513');				// used for sambaPrimaryGroupSID
synchSet('sid',"S-1-5-21-3101180900-1696891574-1772066141");


// add and mod entries are processed after PHPNuke database has been updated
// These definitions are used when creating a new account
// The appropriate group of attributes or scripts is used if the $ldapconfig['var'][group] is non-zero.
$ldapconfig['add']['callFirst'][]			="synchAddSamba";

function synchAddSamba(){
	global $ldapconfig;
	if (synchGet('sambaEnabled')!="1")
		return;

	// sample configuration uses Samba 3.0 schema, fill in the proper settings for your system
	$ldapconfig['add']['ldif']['objectclass'][]		="sambaSamAccount";
	$ldapconfig['add']['ldif']['sambaSid']			="{sid}-{uidnumber}";
	$ldapconfig['add']['ldif']['sambaAcctFlags']		="[U          ]";

	$ldapconfig['add']['ldif']['sambaLmPassword']		="???";
	$ldapconfig['add']['ldif']['sambaNtPassword']		="???";
	$ldapconfig['add']['ldif']['sambaPwdLastSet']		="0";
	$ldapconfig['add']['ldif']['sambaLogonTime']		="0";
	$ldapconfig['add']['ldif']['sambaLogoffTime']		="0";
	$ldapconfig['add']['ldif']['sambaKickoffTime']		="0";
	$ldapconfig['add']['ldif']['sambaPwdCanChange']		="0";
	$ldapconfig['add']['ldif']['sambaPwdMustChange']	="0";
	$ldapconfig['add']['ldif']['sambaHomePath']		="\\\\server\\%user%";
	$ldapconfig['add']['ldif']['sambaHomeDrive']		="H:";
	$ldapconfig['add']['ldif']['sambaLogonScript']		="{sambaLogonScript}";
	$ldapconfig['add']['ldif']['sambaProfilePath']		="\\\\server\\profile\\path";
	$ldapconfig['add']['ldif']['sambaUserWorkstations']	="???";
	$ldapconfig['add']['ldif']['sambaPrimaryGroupSID']	="{sid}-{sambaGroupRID}";
	$ldapconfig['add']['ldif']['sambaDomainName']		="MY-DOMAIN";
	$ldapconfig['add']['ldif']['sambaMungedDial']		=" ";
	$ldapconfig['add']['ldif']['sambaBadPasswordCount']	="0";
	$ldapconfig['add']['ldif']['sambaBadPasswordTime']	="0";
	$ldapconfig['add']['ldif']['sambaPasswordHistory']	="???";
	$ldapconfig['add']['ldif']['sambaLogonHours']		="0";

	synchAddScript	( 'add'
			, '{scriptPath}smbadd.sh {myName} {myPassword} {uidnumber} {gidnumber} "/home/samba/{group}/{myName}"'
			, 'Adding Samba directory /home/samba/{group}/{myName}' ) ;

	// rid = (2*uidnumber)+100
	// primaryGroupRid = (2*gidnumber)+1001
	// Domain Admins rid = 512
	// Domain Users rid = 513
	// Domain Guests rid = 514
}


// Use these fields when making modifications to the ldap database


// Use these when deleting something from the ldap database
// scripts for each matching objectclass will be run after the user is deleted
synchAddScript	( 'del'
		, '{scriptPath}smbdel.sh {myName} "/home/samba/{group}/{myName}"'
		, 'Deleting Samba directory' ) ;

// These definitions used after authentication to login/logout/save information
// uid/username and password should not be included in this list
synchAddScript	( 'setPassword'
		, "{scriptPath}smbsetpasswd.sh {myName} {myPassword}"
		, 'Setting password for {myName}' ) ;


// field definitions for edit form and substitutions
$ldapconfig['addAdminTop']['show'][]			='synchSambaShowAdd';
$ldapconfig['addAdminBottom']['show'][]			='synchSambaShowFields';

$ldapconfig['addAdmin']['get'][]			='synchSambaGet';

$ldapconfig['editAdminTop']['show'][]			='synchSambaShowEdit';
$ldapconfig['editAdminBottom']['show'][]		='synchSambaShowFields';

$ldapconfig['editAdmin']['get'][]			='synchSambaGet';

$ldapconfig['editUserTop']['show'][]			='synchSambaShowEditUser';

$ldapconfig['load'][]					='synchSambaLoad';

function synchSambaLoad(){
	synchSet('sambaEnabled',synchInArray(synchGet('ldap_objectclass'),'sambaSamAccount'));
}

function synchSambaShowAdd(){
	synchSambaShow(true);
}

function synchSambaShowEdit(){
	synchSambaShow(false);
}

function synchSambaShowEditUser(){
	synchSambaShow(false, true);
}

function synchSambaShow($enabled,$user=false){
	global $bgcolor2,$bgcolor3;
	if($user){	// user has color
		$bg1=" bgcolor='$bgcolor2'";
		$bg2=" bgcolor='$bgcolor3'";
		$bf="<b>";
		$bl="</b>";
	}else{		// admin does not
		$bg1="";
		$bg2="";
		$bf="";
		$bl="";
	}

	echo "<tr><td$bg1>{$bf}Samba User$bl</td><td$bg2><INPUT TYPE=CHECKBOX NAME=synchSamba "
	    . (synchGet('sambaEnabled')==1 ? "checked " : "")
	    . ($enabled ? "" : "disabled ")
	    . "</INPUT></td></tr>";
}

function synchSambaShowFields(){
	echo  "<tr><td><b>Samba Info</b></td><td></td></tr>"
	    . "<tr><td>Login Script</td><td><INPUT TYPE=TEXT SIZE=60 NAME=synchSambaLogonScript VALUE='"
	    . str_replace("\\","/",synchGetTranslated('defaultSambaLogonScript'))
	    . "'</INPUT></td></tr>";
}

function synchSambaGet(){
	synchSet('SambaEnabled',$GLOBALS['synchSamba']=='on');		// checkbox returns "on" or nothing
	$script=$GLOBALS['synchSambaLogonScript'];
	synchSet('sambaLogonScript',($script=="")?synchGetTranslated('defaultSambaLogonScript'):str_replace("/","\\",$script));
}

?>
