<?php
/***************************************************************************
 *                             synch-ldap.php
 *                            -------------------
 *   begin                : December 10, 2004
 *   copyright            : (C) 2004 William Wong
 *   email                : bwong at voicenet.com
 *
 *   $Id: synch-ldap.php,v 2.00 2004/12/10 $
 *   $Id: synch-ldap.php,v 1.00 2003/04/10 $
 *
 ***************************************************************************/
/*                                                                      */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */
/*                                                                         */
/***************************************************************************/

if (eregi("synch-ldap.php",$_SERVER['PHP_SELF'])) {
    Header("Location: ../index.php");
    die();
}

if(!defined("SYNCH_LAYER"))
{

define("SYNCH_LAYER","ldap");

function echoAll($x,$pre=""){		// for debugging purposes
	if(is_array($x)){
		echo $pre."= array with ",count($x)." items =<br>";
		foreach($x as $key => $val){
			if(is_array($val)){
				echo $pre.$key."<br>";
				echoAll($val,$pre."-- ");
				echo $pre."<br>";
			} else {
				echo $pre.$key." = ".$val."<br>";
			}
		}
	} else {
		echo $pre.$x."<br>";
	}
}

/***************************************************************************
 * The synchronization system is built around a set of tables that are used
 * by the major functions that create, delete, login, logout and change password.
 * All states generally step through the following sequence.
 *
 *	synchMapCall('callFirst');
 *	synchMapLog();
 *	synchMapCall('call');
 *	synchMapCall('ldap');
 *	synchMapScript();
 *	synchMapCall('callLast');
 *
 ***************************************************************************/

// variable set/get functions
//   set as each state is entered: myName, myPassword, myState
//   sql database values as each state is entered
//   $ldapconfig['login']['sql'][] values copied from ldap server at login

function synchSetArray($array){
	if(is_array($array))
		foreach($array as $key => $val){
			synchSet($key,$val);
		}
}

function synchSet($var,$val){
        global $ldapconfig;
	$ldapconfig['var']['{'.strtolower($var).'}']=$val;
}

function synchGet($var){
        global $ldapconfig;
	return $ldapconfig['var']['{'.strtolower($var).'}'];
}

function synchGetTranslated($var){
        global $ldapconfig;
	return synchTranslate($ldapconfig['var']['{'.strtolower($var).'}']);
}

function synchGetTranslatedArray($var){
        global $ldapconfig;
	return synchTranslateArray($ldapconfig['var']['{'.strtolower($var).'}']);
}

function synchAddScript($type,$exec,$desc){
	global $ldapconfig;
	$ldapconfig[$type]['script'][] = array ('exec'=>$exec, 'desc' => $desc);
}


// ldap parameters
$ldapconfig['ldapVersion']	=3;				// sometimes required, remove line if version selected automatically
$ldapconfig['server']		="ldap://localhost";
$ldapconfig['port']		=389;				// 389 is default ldap port
$ldapconfig['bind_dn']		="cn=manager,dc=wong,dc=dom";
$ldapconfig['password']		="secret";

synchSet('ldapSearchPattern',"{ldapKey}={myName}");
synchSet('ldapKey',"uid");					// ldap user name attribute name
synchSet('passwordAttribute','userPassword');			// ldap password attribute, "" if scripts change password

// System configuration
$ldapconfig['exec']="/usr/bin/sudo";				// remember to make changes to /etc/sudoers file
$ldapconfig['logger']="/usr/bin/logger -t nuke-ldap";  		// use "" to turn off logging

// set password for the following objectclass definitions


// variables used in substitutions
synchSet('nuke',"1");						// required, do not remove

synchSet('peopleBase',"ou=people,dc=wong,dc=dom");
synchSet('groupBase',"ou=group,dc=wong,dc=dom");

synchSet('ScriptPath',"/opt/scripts/");

synchSet('dn',"cn={myName},{peopleBase}");

synchSet('abort',false);					// set to true if subsequent functions should be aborted
synchSet('abortReason',"unknown");
$ldapconfig['abort']['log'][]				="{abortedState} state aborted due to {abortReason}";

// add and mod entries are processed after PHPNuke database has been updated
// These definitions are used when creating a new account
// Typically an 'add' script will create a new user directory
// Typically an 'del' script will delete or backup a user's files

$ldapconfig['add']['log'][]				="Adding user {myName}";

$ldapconfig['add']['ldap'][]				="synchLdapCreate";

$ldapconfig['add']['call'][]				="synchLdapCheck";

// Use these fields when making modifications to the ldap database
$ldapconfig['add']['ldif']['objectclass'][]		="top";
$ldapconfig['add']['ldif']['objectclass'][]		="person";
$ldapconfig['add']['ldif']['objectclass'][]		="organizationalPerson";
$ldapconfig['add']['ldif']['objectclass'][]		="inetOrgPerson";
$ldapconfig['add']['ldif']['objectclass'][]		="nukeaccount";
$ldapconfig['add']['ldif']['uid']			="{myName}";
$ldapconfig['add']['ldif']['userpassword']		="{CRYPT}{cryptPassword}";
$ldapconfig['add']['ldif']['cn']			="{myName}";
$ldapconfig['add']['ldif']['sn']			="{myName}";
$ldapconfig['add']['ldif']['displayname']		="{nuke_name}";

// make sure LDAP values are valid
function synchLdapCheck (){
	if (synchGet('nuke_name')=="")
		synchSet('nuke_name',synchGet('myName'));
}

// Use these when deleting something from the ldap database
// scripts for each matching objectclass will be run after the user is deleted
$ldapconfig['del']['ldap'][]				="synchLdapDestroy";
$ldapconfig['del']['log'][]				="Deleting user {myName}";
$ldapconfig['del']['call'][]				="synchDelNuke";


// These definitions used after authentication to load/save information
// uid/username and password should not be included in this list
$ldapconfig['login']['ldap'][]				="synchLdapLogin";
$ldapconfig['login']['sql']['name']			="{ldap_displayname}";

//$ldapconfig['logout']['ldap'][]			="synchLdapSave";
//$ldapconfig['logout']['ldif']['displayname']		="{nuke_name}";

$ldapconfig['save']['ldap'][]				="synchLdapSave";
$ldapconfig['save']['log'][]				="Updating user {myName}";
$ldapconfig['save']['ldif']['displayname']		="{nuke_name}";


// These field definitions are used for forms associated with the matching function.
// They provide interaction for variables not stored in the database
function synchShowForm($state){
	global $ldapconfig;
	synchMap('call_user_func',$ldapconfig[$state]['show']);
}


function synchGetForm($state){
	global $ldapconfig;
	synchMap('call_user_func',$ldapconfig[$state]['get']);
}


//
// Utility functions
//
function synchExec($cmd){
	global $ldapconfig;
	passthru(escapeshellcmd(synchTranslate($ldapconfig['exec']." ".$cmd)),$return);
	return true;
}


function synchScript($script){
	synchExec($script['exec']);
	return true;
}


function synchLog($text) {
	global $ldapconfig;
	if ($ldapconfig['logger']!="") {
		synchExec($ldapconfig['logger'].synchTranslate(" $text"));
	}
	return true;
}


// Translate array using {var} variable substitution
function synchTranslateArray($input){
	$output=array();
	if(is_array($input)){
		foreach ($input as $key => $str){
			$output["$key"]=synchTranslate($str);
		}
	}
	return $output;
}

// Translate string or array of strings using {var} variable substitution
function synchTranslate($input){
	global $ldapconfig;
	if(is_array($input))
		return synchTranslateArray($input);

//	$input = strtolower($input);					// php 4, faster, converts input to lowercase
	foreach ($ldapconfig['var'] as $var => $val){
		if(!is_array($val)){
			$input = preg_replace("/(".$var.")/i",$val,$input);	// php 4, slower
//		$input = str_replace ($var, $val, $input);			// php 4, faster, converts input to lowercase
//		$input = str_ireplace ($var, $val, $input);			// php 5, faster
		}
	}
	return $input;
}

//
// Map functions, exit functions if 'abort' is true.
//
function synchMap($fn,$params) {
	global $ldapconfig;
	if(is_array($params))
		foreach ($params as $param){
			if (synchGet('abort'))
				return ;
			call_user_func($fn,synchTranslate($param));
		}
}

function synchMapLog() {
	global $ldapconfig;
	synchMap('synchLog',$ldapconfig[synchGet('myState')]['log']);
}

function synchMapScript() {
	global $ldapconfig;
	synchMap('synchScript',$ldapconfig[synchGet('myState')]['script']);
}

function synchMapCall($call) {
	global $ldapconfig;
	synchMap('call_user_func',$ldapconfig[synchGet('myState')][$call]);
}


// create nuke user record
function synchCreateNukeUser(){
	global $db,$user_prefix;
	// check if user already exisits
	if($db->sql_query("select * from ".$user_prefix."_users where username='".synchGet('myName')."'")) {
		return true ;
	} else {
		return $db->sql_query("INSERT INTO ".$user_prefix."_users (user_id, username, user_password)"
				." VALUES (NULL, '".synchGet('myName')."', '".synchEncryptNuke(synchGet('myPasswd'))."'");
	}
}

// load field entries from user table
function synchNukeLoad() {
	global $user_prefix,$db;

	$sresult=$db->sql_query("select * from ".$user_prefix."_users where username='".synchGet('myName')."'");
	if ($sresult == false){
		return false;
	} else {
		//prefix nuke field names with nuke_
		foreach($db->sql_fetchrow($sresult) as $key => $val){
			if(!is_int($key)){
			$result["nuke_".$key]=$val;
			}
		}
		synchSetArray($result);
		return true ;
	}
}

//
// LDAP methods
//
function synchLdapOpen() {
	global $ldapconfig;
	$ldapconfig['ds']=ldap_connect($ldapconfig['server'],$ldapconfig['port']) or die("Cannot connect to ".$ldapconfig['server'].":".$ldapconfig['port']);
	if(isset($ldapconfig['ldapVersion']))
		ldap_set_option($ldapconfig['ds'],LDAP_OPT_PROTOCOL_VERSION, $ldapconfig['ldapVersion']);

	if ( ldap_bind($ldapconfig['ds'],$ldapconfig['bind_dn'],$ldapconfig['password']))
		return true ;

	ldap_close($ldapconfig['ds']);
	die("Cannot bind to ".$ldapconfig['bind_dn']." on ".$ldapconfig['server']);
}

function synchLdapLoad() {
	global $ldapconfig;

	$sresult = synchLdapSearch($ldapconfig['base'],synchGetTranslated('ldapSearchPattern'));
	if (is_array($sresult) && $sresult['count']==1){
		// grab just attributes and values
		foreach($sresult[0] as $k => $v){
			if((!is_int($k)) && is_array($v)){
				if($v['count']==1){
					synchSet('ldap_'.$k,$v[0]);
				} else {
					unset($v['count']);
					synchSet('ldap_'.$k,$v);
				}
			}
		}
		return true;
	}
	return false;
}

function synchLdapSearch($base,$pattern,$atts="") {
	global $ldapconfig;
	synchLdapOpen();
	$result = is_array($atts) ? ldap_search($ldapconfig['ds'],$base,$pattern,$atts)
	                          : ldap_search($ldapconfig['ds'],$base,$pattern);
	if ($result){
		$result=ldap_get_entries($ldapconfig['ds'],$result);
	}
	synchLdapClose();
	return $result;
}

function synchLdapAdd($att) {
	global $ldapconfig;
	return ldap_add($ldapconfig['ds'],synchGetTranslated('dn'),$att);
}

function synchLdapList($search,$fields) {
	global $ldapconfig;
	return ldap_get_entries($ldapconfig['ds'],ldap_list($ldapconfig['ds'],synchGet('peopleBase'),$search,$fields,0));
}

function synchLdapDelete() {
	global $ldapconfig;
	return ldap_delete($ldapconfig['ds'],synchGetTranslated('dn'));
}

function synchLdapReplace($att) {
	global $ldapconfig;
	return ldap_mod_replace($ldapconfig['ds'],synchGetTranslated('dn'),$att);
}

function synchLdapClose() {
	global $ldapconfig;
	return ldap_close($ldapconfig['ds']);
}

// ------  Nuke specific functions ----

function synchEncryptPassword($passwd){
	// generate encrypted password
	$salt="";     //generate a salt using characters [A-Z][a-z][0-9]./
	$chars="./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	for ($i=0;$i<16;$i++) {
		$salt.=$chars[mt_rand(0,strlen($chars))];
	}

	return(crypt($passwd,substr($salt,0,2)));
}

function synchLdapCreate(){
	global $ldapconfig;
	// perform add
	synchLdapOpen();
	if(!synchLdapAdd(synchTranslateArray($ldapconfig['add']['ldif'])))
		synchLog("LDAP create for {myName} failed");
	synchLdapClose();

	synchCreateNukeUser();
}


function synchLdapDestroy(){
	global $ldapconfig;
	synchLdapOpen();
	if(!synchLdapDelete())
		synchLog("LDAP delete for {myName} failed");
	synchLdapClose();
}

function synchEncryptNuke($passwd){
	return md5($passwd);
}

function synchLdapLogin(){
	// save password in nuke user database along with data from the ldap server
	synchSet('nuke_password',synchEncryptNuke(synchGet('myPassword')));

	synchUpdateNukeUser();
}

function synchUpdateNukeUser(){
	global $ldapconfig,$db,$user_prefix;
	$v = "";
	$c = "";
	foreach (synchTranslateArray($ldapconfig['login']['sql']) as $sql => $var ) {
		$v .= $c.$sql."= '".synchTranslate($var)."'";
		$c = ",";
	}
	$result = $db->sql_query("update $user_prefix"."_users set ".$v." where username='".synchGet('myName')."'");
}


function synchLdapLogout(){
	global $ldapconfig;

	// perform save
	synchLdapOpen();
	synchLdapAdd(synchTranslateArray($ldapconfig['logout']['ldif']));
	synchLdapClose();
}


function synchLdapSave(){
	global $ldapconfig;

	// perform save
	synchLdapOpen();
	if(!synchLdapReplace(synchTranslateArray($ldapconfig['save']['ldif'])))
		synchLog("LDAP update for {myName} failed");
	synchLdapClose();
}


function synchLdapEncrypt($passwd){
	$salt="";     //generate a salt using characters [A-Z][a-z][0-9]./
	$chars="./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	for ($i=0;$i<16;$i++) {
		$salt.=$chars[mt_rand(0,strlen($chars))];
	}

	return "{CRYPT}".crypt($passwd,substr($salt,0,2));
}

function synchLdapSetPassword(){
	// change password attribute
	if(synchGet('passwordAttribute')!=""){
		$salt="";     //generate a salt using characters [A-Z][a-z][0-9]./
		$chars="./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for ($i=0;$i<16;$i++) {
			$salt.=$chars[mt_rand(0,strlen($chars))];
		}

		$entry[synchGet('passwordAttribute')]=synchLdapEncrypt(synchGet('myPassword'));
		return synchLdapReplace($entry);
	}
	return null;
}


function synchMapState(){
	synchMapCall('callFirst');
	synchMapLog();
	synchMapCall('call');
	synchMapCall('ldap');
	synchMapScript();
	synchMapCall('callLast');

	if(synchGet('abort')){
	        synchSet('abortedState',synchGet('myState'));
	        synchSet('myState','abort');
		synchMapLog();
		synchMapCall('call');
		synchMapScript();
		return false ;
	} else
		return true;
}


//
// Main synch support functions
//
function synchMapAll($state,$uname,$passwd=""){
	synchSet('myName',$uname);
	synchSet('myPassword',$passwd);
	synchSet('myState',$state);
	synchSet('cryptPassword',synchEncryptPassword($passwd));

	synchNukeLoad();
	synchLdapLoad();

        return synchMapState();
}

function synchLoginFailed(){
        synchSet('myState','loginFailed');
	synchMapLog();
	synchMapCall('call');
	synchMapScript();
}

//
// Main synch functions called from other PHP Nuke modules
//
//	synchIsUser($uname)
//	syncLoad($uname)
//	synchLogin($uname,$passwd)
//	synchLogout($uname)
//	synchAdd($uname,$passwd)
//	synchDelete($uname)
//	synchSave($uname,$passwd="")
//	synchSetPassword($uname,$passwd)
//

// Just check if user record exists
function synchIsUser($uname){
	synchSet('myName',$uname);
	return synchLdapLoad();
}


function synchInArray($array,$str){
	foreach($array as $v){
		if (strcasecmp($v,$str)==0)
			return true;
	}
	return false;
}

function synchLoad($uname){
	global $ldapconfig;
	synchSet('myName',$uname);
	synchNukeLoad();
	synchLdapLoad();
	synchUpdateNukeUser();

	// allow changes based on newly loaded data
	synchMap('call_user_func',$ldapconfig['load']);
}


// login copies ldap to sql, called before PHPNuke uses database
function synchLogin($uname,$passwd){
	global $db,$user_prefix;

	$nukePasswd = synchEncryptNuke($passwd);
	$ldapPasswd = synchLdapEncrypt($passwd);

	synchSet('myName',$uname);
	synchSet('myPassword',$passwd);
	synchSet('myState','login');
	synchSet('cryptPassword',$ldapPasswd);

	if (synchLdapLoad()){
  		// ldap user, check for match
  		$realLdapPasswd = synchGet(synchGet('passwordAttribute'));
  		if ($realLdapPasswd!=$ldapPasswd){
			// prevent user from using old password by setting a really bad one
			$db->sql_query("UPDATE ".$user_prefix."_users SET user_password='"
				.synchEncryptNuke($realLdapPasswd.time())."' WHERE username='$username'");

  		        // process to allow debugging and logging
  		        synchLoginFailed();
			return false ;
		}

		if (!synchNukeLoad()){
			// no local user, ldap user
			// create local user with just the basics, rest will be filled in by login
			synchCreateNukeUser();
		}
		// local and ldap user records exist with matching names and passwords
	} else {
		// no ldap user
		if (synchNukeLoad()){
  			// local and ldap user, check for match
  			if ($nukePasswd!=synchGet('nuke_user_password')){
  			        // password mismatch, login will fail
  			        synchLoginFailed();
				return false ;
			}

  			// local user, no ldap user, change state to add a new user
			synchSet('myState','add');
		} else {
  			// no local user, no ldap user
  			return false;
		}
	}

	// continue with login/add
        return synchMapState();
}


// logout copies sql to ldap, called after user logs out
function synchLogout($uname){
	return synchMapAll('logout',$uname);
}


// add ldap entry, call after new user added to user database
function synchAdd($uname,$passwd){
	return synchMapAll('add',$uname,$passwd);
}


// delete entry from ldap, call when user deleted from user database
function synchDelete($uname){
	return synchMapAll('del',$uname);
}


// update ldap from sql, call after user database updated
function synchSave($uname,$passwd=""){
	return synchMapAll('save',$uname,$passwd);
}


// called when password is changed via add() and update()
function synchSetPassword($uname,$passwd) {
	return synchMapAll('setPassword',$uname,$passwd);
}



// include addition services here
require_once("".$the_include."/synch-ldap-posix.php");
require_once("".$the_include."/synch-ldap-samba.php");
require_once("".$the_include."/synch-ldap-mail.php");


} // if define

?>

