/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <unistd.h>
#include <libmt_client.h>
#include "interface.h"
#include "card.h"
#include "config_utils.h"

extern config_t *config;

static char *str_bid[6] = { _("Inconnue"),
  _("Passe"), _("Prise"), _("Garde"),
  _("Garde Sans"), _("Garde Contre")
};



gint
player_client_init (libmt_client_player_t * player)
{
  player->nick[0] = g_string_new (config->player_name->str);

  g_printerr (player->nick[0]->str);

  return 0;
}


gint
player_client_game_init (libmt_client_player_t * player)
{
  sort_card (player->card, player->nb_hand_card);

  return 0;
}



static void
player_client_draw_desktop (libmt_client_player_t * player, gchar * msg)
{
  GString *st;
  gint i;
  gint pl;
  gint coord_1[MAX_PLAYER] = { LINES - 3, 2, 2, COLS - 3, 0 };
  gint coord_2[MAX_PLAYER] = { LINES - 2, 0, 1, COLS - 1, 0 };

  st = g_string_new ("");

  cls ();

  draw_hand_card (LINES - 5, (COLS - player->nb_hand_card * 2) / 2,
		  player->card, -1);

  set_color (COLOR_WHITE);
  cls_line (0);
  mvaddstr (0, 0, msg);

  for (i = 0, pl = player->place; i < nb_player && pl != -1; i++)
    {
      if ((i % 2) == 0)
	{
	  set_color (COLOR_MAGENTA);
	  if (player->nick[pl] != NULL)
	    mvaddstr_center (coord_1[i], player->nick[pl]->str);
	  set_color (COLOR_YELLOW);
	  mvaddstr_center (coord_2[i], str_bid[player->bid[pl] + 1]);
	}
      else
	{
	  set_color (COLOR_MAGENTA);
	  if (player->nick[pl] != NULL)
	    mvaddstr_vertcenter (coord_1[i], player->nick[pl]->str);
	  set_color (COLOR_YELLOW);
	  mvaddstr_vertcenter (coord_2[i], str_bid[player->bid[pl] + 1]);
	}
      pl += 1;
      if (pl >= nb_player)
	pl = 0;
    }

  refresh ();

  g_string_free (st, TRUE);
}


static void
draw_choose_bid (libmt_client_player_t * player)
{
  gint i;
  GString *st;
  gchar ch1, ch2;

  st = g_string_new ("");

  g_printerr ("PLACE = %d\n", player->place);

  set_color (COLOR_GREEN);
  mvaddstr_center (9, _("Choose :"));
  for (i = 0; i < 5; i++)
    {
      if (player->bid[player->place] == i)
	{
	  set_color (COLOR_YELLOW);
	  ch1 = '>';
	  ch2 = '<';
	}
      else
	{
	  set_color (COLOR_CYAN);
	  ch1 = ' ';
	  ch2 = ' ';
	}
      g_string_sprintf (st, "%c%s%c", ch1, str_bid[i + 1], ch2);
      mvaddstr_center (10 + i, st->str);
    }

  cls_line (LINES - 2);
  set_color (COLOR_YELLOW);
  mvaddstr_center (LINES - 2, str_bid[player->bid[player->place] + 1]);

  refresh ();

  g_string_free (st, TRUE);
}




gint
player_client_make_bid (libmt_client_player_t * player)
{
  int ch;

  player->bid[player->place] = 0;

  player_client_draw_desktop (player, _("Arrow:Choose. Enter to validate."));

  draw_choose_bid (player);

  for (;;)
    {
      ch = getch ();

      if (ch == 13)
	break;

      if (ch == KEY_RIGHT || ch == KEY_DOWN || ch == '6' || ch == '2')
	{
	  player->bid[player->place] += 1;
	  if (LIBMT_BID_CMP (player->bid[player->place], LIBMT_BID_CONTRE) > 0)
	    player->bid[player->place] = LIBMT_BID_PASSE;
	}

      if (ch == KEY_LEFT || ch == KEY_UP || ch == '4' || ch == '8')
	{
	  player->bid[player->place] -= 1;
	  if (LIBMT_BID_CMP (player->bid[player->place], LIBMT_BID_PASSE) < 0)
	    player->bid[player->place] = LIBMT_BID_CONTRE;
	}

      draw_choose_bid (player);
    }

  return 0;
}



gint
player_client_make_chien (libmt_client_player_t * player)
{
  int ch;
  gint card = 0;
  gint card_chien = 0;
  gint sw;

  player_client_draw_desktop (player,
			      _
			      ("[Shift] Arrow:Choose. Space|Tab:Swap. S:Sort. Enter:Validate."));

  draw_hand_card (LINES - 5, (COLS - player->nb_hand_card * 2) / 2,
		  player->card, card);
  draw_chien_card (LINES - 10, (COLS - nb_chien_card * 4) / 2, player->chien,
		   card_chien);

  for (;;)
    {
      ch = getch ();

      if (ch == 13)
	break;

      if (ch == KEY_RIGHT || ch == '6')
	{
	  card += 1;
	  if (card >= player->nb_hand_card)
	    card = 0;
	}

      if (ch == KEY_LEFT || ch == '4')
	{
	  card -= 1;
	  if (card < 0)
	    card = player->nb_hand_card - 1;
	}

      if (ch == KEY_UP || ch == KEY_SRIGHT || ch == '9')
	{
	  card_chien += 1;
	  if (card_chien >= nb_chien_card)
	    card_chien = 0;
	}

      if (ch == KEY_DOWN || ch == KEY_SLEFT || ch == '7')
	{
	  card_chien -= 1;
	  if (card_chien < 0)
	    card_chien = nb_chien_card - 1;
	}

      if (ch == 9 || ch == ' ' || ch == '8' || ch == '5')
	{
	  sw = player->card[card];
	  player->card[card] = player->chien[card_chien];
	  player->chien[card_chien] = sw;
	}

      if (ch == 's' || ch == 'S' || (ch >= '1' && ch <= '3'))
	{
	  sort_card (player->card, player->nb_hand_card);
	  sort_card (player->chien, nb_chien_card);
	}

      draw_hand_card (LINES - 5, (COLS - player->nb_hand_card * 2) / 2,
		      player->card, card);
      draw_chien_card (LINES - 10, (COLS - nb_chien_card * 4) / 2,
		       player->chien, card_chien);
    }

  return 0;
}


gint
player_client_not_make_chien (libmt_client_player_t * player)
{
  return 0;
}



static void
player_client_draw_card_played (libmt_client_player_t * player)
{
  gint i;
  gint pl;
  gint coord_l[MAX_PLAYER] =
    { LINES / 2 + 5, LINES / 2, LINES / 2 - 5, LINES / 2, 0 };
  gint coord_c[MAX_PLAYER] =
    { COLS / 2, COLS / 2 - 5, COLS / 2, COLS / 2 + 5, 0 };

/*   char str[256]; */

  set_color (COLOR_WHITE);
  mvaddstr (LINES / 2, COLS / 2, ".");

  for (i = 0, pl = player->place; i < nb_player; i++)
    {
      draw_card (coord_l[i], coord_c[i], player->card_turn[pl]);
      pl += 1;
      if (pl >= nb_player)
	pl = 0;
    }

/*   for (i = 0; i < nb_player; i++) */
/*     { */
/*       set_color (COLOR_GREEN); */
/*       sprintf (str, "%d", player->card_turn[i]); */
/*       mvaddstr (3, 10 + 4*i, str); */
/*     } */

  refresh ();
}

static void
player_client_draw_card_played_previous_turn (libmt_client_player_t * player)
{
  gint i;
  gint pl;
  gint coord_l[MAX_PLAYER] =
    { LINES / 2 + 5, LINES / 2, LINES / 2 - 5, LINES / 2, 0 };
  gint coord_c[MAX_PLAYER] =
    { COLS / 2, COLS / 2 - 5, COLS / 2, COLS / 2 + 5, 0 };

  set_color (COLOR_WHITE);
  mvaddstr (LINES / 2, COLS / 2, ".");

  for (i = 0, pl = player->place; i < nb_player; i++)
    {
      draw_card (coord_l[i], coord_c[i], player->card_previous_turn[pl]);

      pl += 1;
      if (pl >= nb_player)
	pl = 0;
    }

  refresh ();
}




gint
player_client_choose_card (libmt_client_player_t * player)
{
  gint ch;
  gint ind = 0;

  ind = 0;
  while (player->card[ind] == -1)
    {
      ind += 1;
      if (ind >= player->nb_hand_card)
	ind = 0;
    }


  player_client_draw_desktop (player,
			      _
			      ("[Shift] Arrow:Choose. Space|Tab:Swap. S:Sort. Enter:Validate."));

  player_client_draw_card_played (player);

  draw_hand_card (LINES - 5, (COLS - player->nb_hand_card * 2) / 2,
		  player->card, ind);

  for (;;)
    {
      ch = getch ();

      if (ch == 13)
	break;

      if (ch == KEY_RIGHT || ch == '6')
	{
	  do
	    {
	      ind += 1;
	      if (ind >= player->nb_hand_card)
		ind = 0;
	    }
	  while (player->card[ind] == -1);
	}

      if (ch == KEY_LEFT || ch == '4')
	{
	  do
	    {
	      ind -= 1;
	      if (ind < 0)
		ind = player->nb_hand_card - 1;
	    }
	  while (player->card[ind] == -1);
	}

      if (ch == KEY_DOWN || ch == '2')
	{
	  ind = (ind + player->nb_hand_card / 2) % player->nb_hand_card;
	  while (player->card[ind] == -1)
	    {
	      ind += 1;
	      if (ind >= player->nb_hand_card)
		ind = 0;
	    }
	}

      if (ch == KEY_UP || ch == '8')
	{
	  ind = (ind + player->nb_hand_card / 2) % player->nb_hand_card;
	  while (player->card[ind] == -1)
	    {
	      ind -= 1;
	      if (ind < 0)
		ind = player->nb_hand_card - 1;
	    }
	}

      if (ch == 's' || ch == 'S' || (ch >= '1' && ch <= '3'))
	{
	  sort_card (player->card, player->nb_hand_card);
	  while (player->card[ind] == -1)
	    {
	      ind += 1;
	      if (ind >= player->nb_hand_card)
		ind = 0;
	    }
	}

      player_client_draw_card_played (player);

      draw_hand_card (LINES - 5, (COLS - player->nb_hand_card * 2) / 2,
		      player->card, ind);

/*       draw_card (7, 5, player->card[ind]); */
    }

  player->card_play = player->card[ind];

  return 0;
}


gint
player_client_remove_card (libmt_client_player_t * player)
{
  gint i;

  for (i = 0; i < player->nb_hand_card; i++)
    if (player->card_play == player->card[i])
      player->card[i] = -1;

  return 0;
}




static gint
get_taker_place (libmt_client_player_t * player)
{
  gint i;
  gint bid = 0;
  gint place = -1;

  for (i = 0; i < player->nb_player; i++)
    {
      if (LIBMT_BID_CMP (player->bid[i], bid) > 0)
	{
	  bid = player->bid[i];
	  place = i;
	}
    }

  if (place < 0 || place >= player->nb_player)
    place = 0;

  return place;
}

static void
player_client_draw_resume (libmt_client_player_t * player)
{
  GString *st;
  gint i;
  gint taker_place;
  gint y = 0;

  st = g_string_new ("");

  cls ();

  if (LIBMT_BID_CMP (player->contract, LIBMT_BID_PASSE) == 1
      && LIBMT_BID_CMP (player->contract, LIBMT_BID_CONTRE) == -1)
    {
      taker_place = get_taker_place (player);

      set_color (COLOR_YELLOW);

      g_string_printf (st, _("Taker : %s"), player->nick[taker_place]->str);
      mvaddstr_center (5, st->str);

      /*   if (player->contract */
      g_string_printf (st, _("Contract : %s"), str_bid[player->contract + 1]);
      mvaddstr_center (7, st->str);

      g_string_printf (st, _("%s %s the game"), player->nick[taker_place]->str,
		       (player->taker_is_winner ? "wins" : "loses"));
      mvaddstr_center (9, st->str);

      g_string_printf (st, _("Taker score : %d"), player->taker_score);
      mvaddstr_center (11, st->str);

      g_string_printf (st, _("Taker oudlers : %d"), player->nb_oudler);
      mvaddstr_center (13, st->str);

      y = 15;
    }
  else
    {
      set_color (COLOR_YELLOW);

      mvaddstr_center (5, _("Nobody takes"));
      y = 7;
    }

  mvaddstr_center (y, _("Scores :"));
  for (i = 0; i < player->nb_player; i++)
    {
      set_color (COLOR_YELLOW);
      g_string_printf (st, "%s : %d\n", player->nick[i]->str,
		       player->score[i]);
      mvaddstr_center (y + 1 + i, st->str);
    }

  set_color (COLOR_CYAN);
  mvaddstr_center (LINES - 2, "Press a key to continue or Q to quit");

  if (st != NULL)
    g_string_free (st, TRUE);

  refresh ();
}



gint
player_client_draw (libmt_client_player_t * player)
{
  GString *st;

  st = g_string_new ("");

  switch (player->draw_state)
    {
    case LIBMT_CLIENT_DRAW_OTHER_BID:
      player_client_draw_desktop (player, _("An other player makes its bid"));
      break;

    case LIBMT_CLIENT_DRAW_GET_BID:
      g_string_sprintf (st, _("An other player makes its bid"));
      player_client_draw_desktop (player, st->str);
      break;

    case LIBMT_CLIENT_DRAW_MAKE_CHIEN:
      player_client_draw_desktop (player, _("Ready to make chien"));
      break;

    case LIBMT_CLIENT_DRAW_GET_CHIEN:
      draw_chien_card (LINES - 10, (COLS - nb_chien_card * 4) / 2,
		       player->chien, -1);
      wait_key_press (' ', _("Press space to continue"));
      break;

    case LIBMT_CLIENT_DRAW_START_PLAYING:
      player_client_draw_desktop (player, _("Start to play!"));
      break;

    case LIBMT_CLIENT_DRAW_OTHER_PLAY:
      player_client_draw_desktop (player,
				  _("An other player plays his card"));
      player_client_draw_card_played (player);
      break;

    case LIBMT_CLIENT_DRAW_PAUSE_END_TURN:
      player_client_draw_desktop (player, _("End of turn"));
      player_client_draw_card_played_previous_turn (player);
      wait_key_press (' ', _("Press space to continue"));
      break;

    case LIBMT_CLIENT_DRAW_PAUSE_END_GAME:
      /* show last turn */
      player_client_draw_desktop (player, _("End of turn"));
      player_client_draw_card_played_previous_turn (player);
      wait_key_press (' ', _("Press space to continue"));

      /* show the kitty */
      player_client_draw_desktop (player, _("Kitty was"));
      draw_chien_card (LINES - 10, (COLS - nb_chien_card * 4) / 2,
		       player->chien, -1);
      wait_key_press (' ', _("Press space to continue"));
      break;

    case LIBMT_CLIENT_DRAW_NONE_TAKE:
      draw_chien_card (LINES - 10, (COLS - nb_chien_card * 4) / 2,
		       player->chien, -1);

      wait_key_press (' ', _("Nobody takes. Press space to continue"));
      break;
    }

  g_string_free (st, TRUE);

  return 0;
}



gint
player_client_ack_replay (libmt_client_player_t * player)
{
  char ch;

  player->replay = TRUE;

  /* show a resume of the game */
  player_client_draw_resume (player);

  for (;;)
    {
      ch = getch ();

      if (ch == 'Q' || ch == 'q')
	{
	  player->replay = FALSE;
	  break;
	}

      if (ch != 0)
	break;
    }

  return 0;
}

gint
player_client_lost_connection (libmt_client_player_t * player)
{
  player_client_draw_desktop (player, _("Someone have quit the game"));
  player_client_draw_card_played_previous_turn (player);
  wait_key_press (' ', _("LOST CONNECTION : Press space to continue"));

  return 0;
}

gint
player_client_normal_close (libmt_client_player_t * player)
{
/*   player_client_draw_desktop (player, _("End of game")); */
/*   player_client_draw_card_played_previous_turn (player); */
/*   wait_key_press (' ', _("Press space to continue")); */

  return 0;
}
