/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a
#ifdef GNOME2
#include <gnome.h>
#endif
#include <gtk/gtk.h>
#include <stdio.h>
#include <libmt_client.h>
#include <config.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include "gui.h"
#include "defs.h"
#include "player.h"
#include "gui_sort_card.h"
#include "gui_program.h"
#include "gui_config.h"
#include "config_utils.h"

GtkWidget *gui_mainwin = NULL;
GtkWidget *gui_layout;
GtkWidget *gui_statusbar;
GtkWidget *gui_menubar;
GtkItemFactory *gui_item_factory;
GtkAccelGroup *gui_accel_group;

GtkWidget *gui_card_img[NUMBER_OF_CARD + 1];
gint gui_card_width, gui_card_height;

gint gui_card_sort[NUMBER_OF_CARD + 1];

static GtkWidget *vbox;

static GtkWidget *frame_button;
static GtkWidget *entry_name;

static GtkWidget *logo_image;


static libmt_client_player_t player;

static void gui_main_quit (void);
static void gui_main_draw (void);
static void gui_main_redraw (GtkWidget * win, GdkEventConfigure * evt,
			     gpointer data);
static gpointer gui_thread_func (gpointer data);

static void gui_do_menubar (void);

static void gui_about (void);




static gui_redraw_func_t gui_redraw_func;
static gpointer gui_redraw_data;


static void
gui_general_redraw (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  g_string_printf (config->gui_info_geometry, "%dx%d+%d+%d\n",
		   evt->width, evt->height, evt->x, evt->y);

/*   g_print ("geom=%s\n", config->gui_info_geometry->str); */

  if (gui_redraw_func)
    gui_redraw_func (win, evt, gui_redraw_data);
}


void
gui_set_redraw_func (gui_redraw_func_t func, gpointer data)
{
  gui_redraw_func = func;
  gui_redraw_data = data;
}




void
gui_do_redraw (void)
{
  GdkEventConfigure evt;

  gtk_window_get_size (GTK_WINDOW (gui_mainwin), &evt.width, &evt.height);

  if (gui_redraw_func)
    gui_redraw_func (gui_mainwin, &evt, gui_redraw_data);
}


static void
start_program (void)
{
  GtkWidget *wid;

  g_string_printf (config->gui_player_name, "%s",
		   gtk_entry_get_text (GTK_ENTRY (entry_name)));

  if (gui_start_program ())
    {
      wid = gtk_message_dialog_new (GTK_WINDOW (gui_mainwin),
				    GTK_DIALOG_DESTROY_WITH_PARENT,
				    GTK_MESSAGE_ERROR,
				    GTK_BUTTONS_CLOSE,
				    "%s\n",
				    _("Can't find maitretarot_server or IA programs"));
      gtk_dialog_run (GTK_DIALOG (wid));
      gtk_widget_destroy (wid);      
    }
}

static void
start_all_programs (void)
{
  g_string_printf (config->gui_player_name, "%s",
		   gtk_entry_get_text (GTK_ENTRY (entry_name)));

  gui_connect_to_other_game ();
}



static void
gui_main_draw (void)
{
  gint width = WIDTH, height = HEIGHT;
  GtkRequisition req;
  GtkWidget *wid, *frame;

  /* Button Single and Multi Users */
  frame_button = gtk_vbutton_box_new ();
  gtk_box_set_spacing (GTK_BOX (frame_button), 15);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (frame_button),
			     GTK_BUTTONBOX_SPREAD);

  /* Name frame */
  frame = gtk_frame_new (_(" Name "));
  gtk_box_pack_start (GTK_BOX (frame_button), frame, FALSE, FALSE, 5);

  entry_name = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (entry_name), config->gui_player_name->str);

  gtk_container_add (GTK_CONTAINER (frame), entry_name);

  /* separator */
  wid = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (frame_button), wid, FALSE, FALSE, 5);


  /* Single User button */
  wid = gtk_button_new_with_mnemonic (_("Single _User"));
  g_signal_connect (G_OBJECT (wid), "clicked", G_CALLBACK (start_program),
		    NULL);

  gtk_widget_add_accelerator (wid, "clicked", gui_accel_group,
			      GDK_Return, 0, GTK_ACCEL_VISIBLE);

  gtk_box_pack_start (GTK_BOX (frame_button), wid, FALSE, FALSE, 5);


  /* Multi User button */
  wid = gtk_button_new_with_mnemonic (_("_Multi Users (Network)"));
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (start_all_programs), NULL);
  gtk_box_pack_start (GTK_BOX (frame_button), wid, FALSE, FALSE, 5);

  /* separator */
  wid = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (frame_button), wid, FALSE, FALSE, 5);

  /* qui button */
  wid = gtk_button_new_from_stock (GTK_STOCK_QUIT);
  g_signal_connect (G_OBJECT (wid), "clicked", G_CALLBACK (gui_main_quit),
		    NULL);
  gtk_box_pack_start (GTK_BOX (frame_button), wid, FALSE, FALSE, 5);



  /* Place the frame */
  gtk_widget_size_request (GTK_WIDGET (frame_button), &req);
  gtk_layout_put (GTK_LAYOUT (gui_layout), frame_button,
		  width - 1.5 * req.width, height / 2 - req.width / 2);

  /* Place the logo */
  gtk_layout_put (GTK_LAYOUT (gui_layout), logo_image, 20, 20);
}


static void
gui_main_redraw (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  GtkRequisition req;
  gint width, height;

  if (!config->gui_start_screen)
    return;

  gui_layout_get_size (evt, &width, &height);

  gtk_widget_size_request (GTK_WIDGET (frame_button), &req);

  gtk_layout_move (GTK_LAYOUT (gui_layout), frame_button,
		   width - 1.5 * req.width, height / 2 - req.height / 2);
}



static gpointer
gui_thread_func (gpointer data)
{
  libmt_client_main_loop (&player, config->gui_host_name, config->gui_port,
			  CLIENT_ID, CLIENT_VERSION);

  g_thread_exit (NULL);

  return (NULL);
}


void
gui_start_game (void)
{
  gui_clear_layout ();

  libmt_client_init (&player, 4, 18, 6);

  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_INIT, player_client_init);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_GAME_INIT,
			      player_client_game_init);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_MAKE_BID,
			      player_client_make_bid);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_MAKE_CHIEN,
			      player_client_make_chien);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_NOT_MAKE_CHIEN,
			      player_client_not_make_chien);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_CHOOSE_CARD,
			      player_client_choose_card);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_REMOVE_CARD,
			      player_client_remove_card);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_DRAW, player_client_draw);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_ACK_REPLAY,
			      player_client_ack_replay);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_LOST_CONNECTION,
			      player_client_lost_connection);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_NORMAL_CLOSE,
			      player_client_normal_close);

  g_thread_create (gui_thread_func, NULL, FALSE, NULL);
}



int
gui_init (int argc, char **argv)
{
  GdkColor color;
  gint i;

  gtk_set_locale ();

#ifdef GNOME2
  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
		      argc, argv,
		      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR, NULL);
#else
  gtk_init (&argc, &argv);
#endif

  gui_accel_group = gtk_accel_group_new ();

  gui_load_images ();

  gui_init_card_sort ();

  /* main window */
  gui_mainwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (gui_mainwin), "Maitretarot GTK+ Client");

  g_printerr ("geom=%s\n", config->gui_geometry->str);

  if (! gtk_window_parse_geometry
      (GTK_WINDOW (gui_mainwin), config->gui_geometry->str))
    {
      gtk_window_set_default_size (GTK_WINDOW (gui_mainwin), WIDTH, HEIGHT);
    }

  g_signal_connect (G_OBJECT (gui_mainwin), "destroy",
		    G_CALLBACK (gui_main_quit), NULL);

  /* vbox for menu, layout, chat and status bar */
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (gui_mainwin), vbox);

  /* Menu Bar */
  gui_do_menubar ();
  gtk_box_pack_start (GTK_BOX (vbox), gui_menubar, FALSE, FALSE, 0);

  /* layout */
  gui_layout = gtk_layout_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX (vbox), gui_layout, TRUE, TRUE, 0);

  gdk_color_parse (config->gui_layout_bg_color->str, &color);
  gtk_widget_modify_bg (GTK_WIDGET (gui_layout), GTK_STATE_NORMAL, &color);

  /* Status bar */
  gui_statusbar = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (vbox), gui_statusbar, FALSE, FALSE, 0);

  for (i = 0; i < NUMBER_OF_CARD + 1; i++)
    {
      gtk_layout_put (GTK_LAYOUT (gui_layout), gui_card_img[i], X_HIDE,
		      Y_HIDE);
    }

  if (config->gui_start_screen)
    gui_main_draw ();

  gtk_widget_show_all (gui_mainwin);

  gui_set_redraw_func (gui_main_redraw, NULL);
  gui_do_redraw ();
  g_signal_connect (G_OBJECT (gui_mainwin), "configure-event",
		    G_CALLBACK (gui_general_redraw), NULL);

  if (!gui_valide_customize ())
    gui_sort_card_HCDST ();

  if (!config->gui_start_screen)
    gui_start_game ();

  return (0);
}


static void
gui_main_quit (void)
{
  gtk_widget_destroy (gui_mainwin);

  gtk_main_quit ();
}



void
gui_clear_layout (void)
{
  gui_set_redraw_func (NULL, NULL);

  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0, "");

  if (config->gui_start_screen)
    {
      gtk_widget_hide_all (GTK_WIDGET (frame_button));

      gtk_container_remove (GTK_CONTAINER (gui_layout), frame_button);
      gtk_container_remove (GTK_CONTAINER (gui_layout), logo_image);
    }
}



void
gui_layout_get_size (GdkEventConfigure * evt, gint * width, gint * height)
{
  GtkRequisition req;

  *width = evt->width;
  *height = evt->height;

/*   g_print ("geom get sixe=%dx%d\n", *width, *height); */

  gtk_widget_size_request (GTK_WIDGET (gui_menubar), &req);
  *height -= req.height;

  gtk_widget_size_request (GTK_WIDGET (gui_statusbar), &req);
  *height -= req.height;

  gtk_layout_set_size (GTK_LAYOUT (gui_layout), *width, *height);
}




gint
gui_load_images (void)
{
  gint i;
  GString *st;
  GtkWidget *wid;
  GtkRequisition req;
  GdkColor color;


  st = g_string_new ("");

  g_print ("cardpics dir : %s\n", config->cardpics_dir->str);

  for (i = 0; i < NUMBER_OF_CARD + 1; i++)
    {
      g_string_printf (st, "%s/%02d.png", config->cardpics_dir->str, i);

      wid = gtk_image_new_from_file (st->str);
      gtk_widget_size_request (wid, &req);
      gui_card_width = req.width;
      gui_card_height = req.height;

      gui_card_img[i] = gtk_event_box_new ();

      gtk_container_add (GTK_CONTAINER (gui_card_img[i]), wid);

      gdk_color_parse (config->gui_layout_bg_color->str, &color);
      gtk_widget_modify_bg (GTK_WIDGET (gui_card_img[i]), GTK_STATE_NORMAL,
			    &color);

      g_object_ref (gui_card_img[i]);
    }

  g_string_printf (st, "%s/data/maitretarot.png", DATA_DIR);
  logo_image = gtk_image_new_from_file (st->str);

  g_string_free (st, TRUE);
  return (0);
}






static void
gui_do_menubar (void)
{
  GtkItemFactoryEntry menu_items[] = {
    {_("/_Games"), NULL, 0, 0, "<Branch>"},
    {_("/Games/tearoff2"), NULL, 0, 0, "<Tearoff>"},
    {_("/Games/sep20"), NULL, 0, 0, "<Separator>"},
    {_("/Games/_Quit"), "<control>Q", gui_main_quit, 0},

    {_("/_Sort Cards"), NULL, 0, 0, "<Branch>"},
    {_("/Sort Cards/tearoff1"), NULL, 0, 0, "<Tearoff>"},
    {_("/Sort Cards/_Heart-Club-Diamond-Spade-Trump"), "<shift>H",
     gui_sort_card_HCDST, 0},
    {_("/Sort Cards/H_eart-Club-Trump-Diamond-Spade"), "<shift>E",
     gui_sort_card_HCTDS, 0},
    {_("/Sort Cards/_Trump-Heart-Club-Diamond-Spade"), "<shift>T",
     gui_sort_card_THCDS, 0},
    {_("/Sort Cards/sep10"), NULL, 0, 0, "<Separator>"},
    {_("/Sort Cards/_Ascendant Order"), "<shift>A", gui_sort_card_ascendant,
     0},
    {_("/Sort Cards/_Descendant Order"), "<shift>D", gui_sort_card_descendant,
     0},
    {_("/Sort Cards/sep11"), NULL, 0, 0, "<Separator>"},
    {_("/Sort Cards/_Upper Order"), "<shift>U", gui_sort_card_upper, 0},
    {_("/Sort Cards/_Lower Order"), "<shift>L", gui_sort_card_lower, 0},
    {_("/Sort Cards/sep12"), NULL, 0, 0, "<Separator>"},
    {_("/Sort Cards/_Customize"), "<shift>C", gui_sort_card_customize, 0},

    {_("/Ch_at"), NULL, 0, 0, "<Branch>"},

    {_("/_Configuration"), NULL, 0, 0, "<Branch>"},
    {_("/Configuration/_Background Color"), NULL, gui_set_bg_color, 0},
    {_("/Configuration/_Geometry"), NULL, gui_set_geometry, 0},
    {_("/Configuration/sep30"), NULL, 0, 0, "<Separator>"},
    {_("/Configuration/_Save configuration"), NULL, gui_save_config, 0},

    {_("/_Help"), NULL, 0, 0, "<LastBranch>"},
    {_("/Help/_About"), NULL, gui_about, 0}
  };
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

  gui_item_factory =
    gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", gui_accel_group);
  g_object_set_data_full (G_OBJECT (gui_mainwin), "<main>", gui_item_factory,
			  (GDestroyNotify) g_object_unref);
  gtk_window_add_accel_group (GTK_WINDOW (gui_mainwin), gui_accel_group);
  gtk_item_factory_create_items (gui_item_factory, nmenu_items, menu_items,
				 NULL);

  gui_menubar = gtk_item_factory_get_widget (gui_item_factory, "<main>");
}





static void
gui_about (void)
{
  GtkWidget *wid;

  wid = gtk_message_dialog_new (GTK_WINDOW (gui_mainwin),
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_CLOSE,
				"%s\n%s\n%s%s\n\n%s\n%s\n\n%s\n\n%s\n%s",
				_("MaitreTarot GTK+ Client"),
				_("A french tarot game"),
				_("Version "), VERSION,
				"Copyright (C) 2002 Philippe 'Hocwp' Brochard",
				"<hocwp@free.fr>",
				_
				("MaitreTarot GTK+ Client is distributed under the terms of the\n"
				"GNU General Public Licence"),
				_
				("For more information about this application visit"),
				"http://www.nongnu.org/maitretarot/");
  gtk_dialog_run (GTK_DIALOG (wid));
  gtk_widget_destroy (wid);
}
