/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <libintl.h>

#include "gui.h"
#include "player.h"

#define _(a) gettext (a)



static GtkWidget * win = NULL;
static gint done = 0;



static void
response (GtkDialog *dialog, gint resp, gpointer user_data)
{
  libmt_client_player_t * player = user_data;

  if (resp == GTK_RESPONSE_ACCEPT)
    player->replay = TRUE;
  else
    {
      player->replay = FALSE;
      
      /* FIXME: remove this when segfault is solved */
      exit (-1);
    }

  done = 1;

  gtk_widget_destroy (win);
}





static gint
get_taker_place (libmt_client_player_t * player)
{
  gint i;
  gint bid = 0;
  gint place = -1;

  for (i = 0; i < player->nb_player; i++)
    {
      if (LIBMT_BID_CMP (player->bid[i], bid) > 0)
	{
	  bid = player->bid[i];
	  place = i;
	}
    }

  if (place < 0 || place >= player->nb_player)
    place = 0;

  return place;
}




gint
player_client_ack_replay (libmt_client_player_t * player)
{
  GtkWidget * gbox;
  GtkWidget * frame;
  GtkWidget * wid;
  gint taker_place;
  GString *st;
  gint i;

  st = g_string_new ("");

  taker_place = get_taker_place (player);

  gdk_threads_enter ();

  /* Top window */
  win = gtk_dialog_new_with_buttons ("Maitretarot GTK+ Client",
				     GTK_WINDOW (gui_mainwin),
				     GTK_DIALOG_DESTROY_WITH_PARENT,
				     GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
				     GTK_STOCK_QUIT, GTK_RESPONSE_NONE,
				     NULL);

  /* main frame */
  frame = gtk_frame_new (NULL);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(win)->vbox), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

  gbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), gbox);
  gtk_container_set_border_width (GTK_CONTAINER (gbox), 5);

  /* Taker label */
  if (LIBMT_BID_CMP (player->contract, LIBMT_BID_PASSE) == 1
      && LIBMT_BID_CMP (player->contract, LIBMT_BID_CONTRE) == -1)
    {
      g_string_printf (st, _("Taker : %s"), player->nick[taker_place]->str);
      wid = gtk_label_new (st->str);
      gtk_container_add (GTK_CONTAINER (gbox), wid);

      g_string_printf (st, _("Contract : %s"), str_bid[player->contract + 1]);
      wid = gtk_label_new (st->str);
      gtk_container_add (GTK_CONTAINER (gbox), wid);

      g_string_printf (st, _("%s %s the game"), player->nick[taker_place]->str,
		       (player->taker_is_winner ? "wins" : "loses"));
      wid = gtk_label_new (st->str);
      gtk_container_add (GTK_CONTAINER (gbox), wid);

      g_string_printf (st, _("Taker score : %d"), player->taker_score);
      wid = gtk_label_new (st->str);
      gtk_container_add (GTK_CONTAINER (gbox), wid);

      g_string_printf (st, _("Taker oudlers : %d"), player->nb_oudler);
      wid = gtk_label_new (st->str);
      gtk_container_add (GTK_CONTAINER (gbox), wid);
    }
  else 
    {
      wid = gtk_label_new (_("Nobody takes"));
      gtk_container_add (GTK_CONTAINER (gbox), wid);
    }

  wid = gtk_hseparator_new ();
  gtk_container_add (GTK_CONTAINER (gbox), wid);

  wid = gtk_label_new (_("Scores"));
  gtk_container_add (GTK_CONTAINER (gbox), wid);

  for (i = 0; i < player->nb_player; i++)
    {
      g_string_printf (st, "%s : %d", player->nick[i]->str, player->score[i]);
      wid = gtk_label_new (st->str);
      gtk_container_add (GTK_CONTAINER (gbox), wid);
    }


 g_signal_connect (GTK_OBJECT (win), 
		   "response", 
		   G_CALLBACK (response),
		   player);


  gtk_widget_show_all (win);

  gui_set_redraw_func (player_client_redraw_base, player);
  gui_do_redraw ();

  gdk_threads_leave ();

  done = 0;
  while (done == 0)
    {
      usleep (100);
    }

  g_string_free (st, TRUE);

  return 0;
}

