/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007, 2008 Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Ogg::Error implementation interface                                       */
/*                                                                           */
/*===========================================================================*/
#ifndef ErrorImplInterface
#define	ErrorImplInterface

#ifdef __GNUG__
#pragma interface
#endif

#include	<Ogg/Exception.H>

#include	<string>
#include	<map>
#include	<bitset>

///
///@file <src/lib/ErrorImpl.H>
///
namespace	Ogg
{
  /// @brief Error implementation interface
  ///
  /// @ingroup transportImplementation
  ///
  class ErrorImpl
    : public Error
  {
    friend class Error;
    friend class PageImpl;
    friend class PageDecapser;
    friend class PacketImpl;

  private:
    static
    std::map<ErrorNo,std::string>	descriptions_;

    static
    void
    initDescriptions();

    std::bitset<16>			bits_;

    ErrorImpl();

    ~ErrorImpl()
    {}

    void
    clear();
  };
}
#endif
