#!/bin/bash
source lfs-install.conf
source lfs-install_chapter3.func
source lfs-install_chapter4.func
source lfs-install_chapter5.func
source lfs-install_chapter6.func
source lfs-install_chapter7.func
source lfs-install_chapter8.func
source lfs-install_chapter9.func
source lfs-install_cdrom.func

function main
{
	# lfs chapter 4
	creating_partition
	creating_filesystem
	mounting_partition

	# lfs chapter 3
	if [ ! -d $LFSINSTALL_CACHE ]
	then
		download_packages
		verify_packages
	fi

	if [ ! -d $LFSINSTALL_SWAP ]
	then
		unpack_packages
	fi

	# lfs chapter 5
	optimize_packages
	precompile_packages

	# lfs chapter 6
	compile_packages

	# lfs chapter 7
	configure_packages

	# lfs chapter 8
	configure_packages2

	# lfs chapter 9
	configure_packages3

	# lfs-install cdrom
	echo -n "Build cdrom: "
	read cdrom
	if [ "$cdrom" == "y" ]
	then
		build_cdrom
	else
		exit
	fi
}

main
