#!/bin/bash
# lfs_compile.sh
source program/lfs-install.config

function DoOptimization ()
{
	clear
	echo		"Optimization flags"
	echo		"--------------------------------------------------------------------------------"
	echo		""
	echo		"[1]  Intel 386                         [5]  Intel Pentium Pro"
	echo		"[2]  Intel 486                         [6]  Intel Pentium II"
	echo		"[3]  Intel Pentium                     [7]  Intel Pentium III"
	echo		"[4]  Intel Pentium MMX                 [8]  Intel Pentium IV"
	echo		""
	echo		"[9]  AMD K6                            [13] AMD Athlon 2 (Thunderbird)"
	echo		"[10] AMD K6-II                         [14] AMD Athlon XP"
	echo		"[11] AMD K6-III                        [15] AMD Athlon 4 (Palamino)"
	echo		"[12] AMD Athlon                        [16] AMD Athlon MP"
	echo		""
	echo		"[17] Via C3"
	echo		""
	echo		"[18] No optimization                   [0]  Custom options"
	echo		""
	echo		""
	echo -n		"Enter processor number: "
	read		number

	if		[ "$number" = "1" ]; then
				CHOST="i386-pc-linux-gnu"
				CFLAGS="-march=i386 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=i386 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=i386 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=i386 -O3 -pipe"
				lfs_arch="i386"
				lfs_kernel="386"
	elif		[ "$number" = "2" ]; then
				CHOST="i486-pc-linux-gnu"
				CFLAGS="-march=i486 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=i486 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=i486 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=i486 -O3 -pipe"
				lfs_arch="i486"
				lfs_kernel="486"
	elif		[ "$number" = "3" ]; then
				CHOST="i586-pc-linux-gnu"
				CFLAGS="-march=pentium -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=pentium -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=pentium -O3 -pipe"
				CXXFLAGS_GLIBC="-march=pentium -O3 -pipe"
				lfs_arch="i586"
				lfs_kernel="pentium"
	elif		[ "$number" = "4" ]; then
				CHOST="i586-pc-linux-gnu"
				CFLAGS="-march=pentium-mmx -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=pentium-mmx -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=pentium-mmx -O3 -pipe"
				CXXFLAGS_GLIBC="-march=pentium-mmx -O3 -pipe"
				lfs_arch="i586"
				lfs_kernel="pentium-mmx"
	elif		[ "$number" = "5" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=pentiumpro -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=pentiumpro -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=pentiumpro -O3 -pipe"
				CXXFLAGS_GLIBC="-march=pentiumpro -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="pentiumpro"
	elif		[ "$number" = "6" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=pentium2 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=pentium2 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=pentium2 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=pentium2 -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="pentium2"
	elif		[ "$number" = "7" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=pentium3 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=pentium3 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=pentium3 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=pentium3 -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="pentium3"
	elif		[ "$number" = "8" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=pentium4 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=pentium4 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=pentium4 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=pentium4 -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="pentium4"
	elif		[ "$number" = "9" ]; then
				CHOST="i586-pc-linux-gnu"
				CFLAGS="-march=k6 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=k6 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=k6 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=k6 -O3 -pipe"
				lfs_arch="i586"
				lfs_kernel="k6"
	elif		[ "$number" = "10" ]; then
				CHOST="i586-pc-linux-gnu"
				CFLAGS="-march=k6-2 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=k6-2 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=k6-2 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=k6-2 -O3 -pipe"
				lfs_arch="i586"
				lfs_kernel="k6"
	elif		[ "$number" = "11" ]; then
				CHOST="i586-pc-linux-gnu"
				CFLAGS="-march=k6-3 -O3 -pipe -fomit-frame-pointer"
				CFLAGS="-march=k6-3 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=k6-3 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=k6-3 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=k6-3 -O3 -pipe"
				lfs_arch="i586"
				lfs_kernel="k6"
	elif		[ "$number" = "12" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=athlon -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=athlon -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=athlon -O3 -pipe"
				CXXFLAGS_GLIBC="-march=athlon -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="k7"
	elif		[ "$number" = "13" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=athlon-tbird -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=athlon-tbird -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=athlon-tbird -O3 -pipe"
				CXXFLAGS_GLIBC="-march=athlon-tbird -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="k7"
	elif		[ "$number" = "14" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=athlon-xp -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=athlon-xp -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=athlon-xp -O3 -pipe"
				CXXFLAGS_GLIBC="-march=athlon-xp -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="k7"
	elif		[ "$number" = "15" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=athlon-4 -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=athlon-4 -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=athlon-4 -O3 -pipe"
				CXXFLAGS_GLIBC="-march=athlon-4 -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="k7"
	elif		[ "$number" = "16" ]; then
				CHOST="i686-pc-linux-gnu"
				CFLAGS="-march=athlon-mp -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=athlon-mp -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=athlon-mp -O3 -pipe"
				CXXFLAGS_GLIBC="-march=athlon-mp -O3 -pipe"
				lfs_arch="i686"
				lfs_kernel="k7"
	elif		[ "$number" = "17" ]; then
				CHOST="i586-pc-linux-gnu"
				CFLAGS="-march=i586 -m3dnow -O3 -pipe -fomit-frame-pointer"
				CXXFLAGS="-march=i586 -m3dnow -O3 -pipe -fomit-frame-pointer"
				CFLAGS_GLIBC="-march=i586 -m3dnow -O3 -pipe"
				CXXFLAGS_GLIBC="-march=i586 -m3dnow -O3 -pipe"
				lfs_arch="i586"
				lfs_kernel="c3"
	elif		[ "$number" = "18" ]; then
				CHOST=""
				CFLAGS=""
				CXXFLAGS=""
				CFLAGS_GLIBC=""
				CXXFLAGS_GLIBC=""
				lfs_arch="i386"
				lfs_kernel="386"
	elif		[ "$number" = "0" ]; then
				echo -n "Enter CHOST options: "
				read CHOST
				echo -n "Enter CFLAGS options: "
				read CFLAGS
				echo -n "Enter CXXFLAGS options: "
				read CXXFLAGS
				echo -n "Enter CFLAGS_GLIBC options: "
				read CFLAGS_GLIBC
				echo -n "Enter CXXFLAGS_GLIBC options: "
				read CXXFLAGS_GLIBC
				echo -n "Enter architecture options: "
				read lfs_arch
				echo -n "Enter kernel options: "
				read lfs_kernel
	else
			DoOptimization
	fi
}

function DoChroot ()
{
	chroot          $lfs_root /static/bin/env -i CHOST="`echo $CHOST`" CFLAGS="`echo $CFLAGS`" CXXFLAGS="`echo $CXXFLAGS`" lfs_arch="`echo $lfs_arch`" HOME=/root TERM=$TERM PS1='\u:\w\$ ' PATH=/bin:/usr/bin:/sbin:/usr/sbin:/static/bin /static/bin/bash /static/tmp/lfs-commands/$1
}

function DoChroot_Glibc ()
{
	chroot          $lfs_root /static/bin/env -i CHOST="`echo $CHOST`" CFLAGS="`echo $CFLAGS_GLIBC`" CXXFLAGS="`echo $CXXFLAGS_GLIBC`" lfs_arch="`echo $lfs_arch`" HOME=/root TERM=$TERM PS1='\u:\w\$ ' PATH=/bin:/usr/bin:/sbin:/usr/sbin:/static/bin /static/bin/bash /static/tmp/lfs-commands/$1
}

function DoCompile ()
{
	if		[ "$1" = "static" ]; then
				cp $lfsinstall_swap/linuxfromscratch/lfs-packages/$2* $lfs_root/usr/src/

				cd $lfs_root/usr/src/

				for	filename in *.tar.bz2; do
						tar xfjv $filename
						rm $filename
				done

				for	filename in *.patch.bz2; do
						bzip2 -dv $filename
				done

				cd -

				$lfsinstall_swap/linuxfromscratch/lfs-commands/$3*

				rm -rf $lfs_root/usr/src/$2*
	fi

	if		[ "$1" = "dynamic" ]; then
				cp $lfsinstall_swap/linuxfromscratch/lfs-packages/$2* $lfs_root/usr/src/

				cd $lfs_root/usr/src/

				for	filename in *.tar.bz2; do
						tar xfjv $filename
						rm $filename
				done

				for	filename in *.patch.bz2; do
						bzip2 -dv $filename
				done

				for	filename in *.bz2; do
						bzip2 -dv $filename
				done

				cd -

				if [ "$2" = "glibc" ]; then
					DoChroot_Glibc $3
				else
					DoChroot $3
				fi

				rm -rf $lfs_root/usr/src/$2*
	fi
}

function DoPrecompilation ()
{
	DoCompile	static		bash		chapter5/Bash
	DoCompile	static		binutils	chapter5/Binutils
	DoCompile	static		bzip2		chapter5/Bzip2
	DoCompile	static		diffutils	chapter5/Diffutils
	DoCompile	static		fileutils	chapter5/Fileutils
	DoCompile	static		findutils	chapter5/Findutils
	DoCompile	static		gawk		chapter5/Gawk
	DoCompile	static		gcc		chapter5/GCC
	DoCompile	static		grep		chapter5/Grep
	DoCompile	static		gzip		chapter5/Gzip
	DoCompile	static		make		chapter5/Make
	DoCompile	static		patch		chapter5/Patch
	DoCompile	static		sed		chapter5/Sed
	DoCompile	static		sh-utils	chapter5/Sh-utils
	DoCompile	static		tar		chapter5/Tar
	DoCompile	static		texinfo		chapter5/Texinfo
	DoCompile	static		textutils	chapter5/Textutils
	DoCompile	static		util-linux	chapter5/Util-linux
}

function DoCompilation ()
{
	DoCompile	dynamic		MAKEDEV		chapter6/creating_devices
	DoCompile	dynamic		linux		chapter6/Linux-2.4.19
	DoCompile	dynamic		man-pages	chapter6/Man-pages-1.52
	DoCompile	dynamic		glibc		chapter6/Glibc-2.2.5
	DoCompile	dynamic		gcc		chapter6/GCC-3.2
	DoCompile	dynamic		zlib		chapter6/Zlib-1.1.4
	DoCompile	dynamic		findutils	chapter6/Findutils-4.1
	DoCompile	dynamic		gawk		chapter6/Gawk-3.1.1
	DoCompile	dynamic		ncurses		chapter6/Ncurses-5.2
	DoCompile	dynamic		vim		chapter6/Vim-6.1
	DoCompile	dynamic		bison		chapter6/Bison-1.35
	DoCompile	dynamic		less		chapter6/Less-374
	DoCompile	dynamic		groff		chapter6/Groff-1.18
	DoCompile	dynamic		textutils	chapter6/Textutils-2.1
	DoCompile	dynamic		sed		chapter6/Sed-3.02
	DoCompile	dynamic		flex		chapter6/Flex-2.5.4a
	DoCompile	dynamic		binutils	chapter6/Binutils-2.13
	DoCompile	dynamic		fileutils	chapter6/Fileutils-4.1
	DoCompile	dynamic		sh-utils	chapter6/Sh-utils-2.0
	DoCompile	dynamic		gettext		chapter6/Gettext-0.11.5
	DoCompile	dynamic		net-tools	chapter6/Net-tools-1.60
	DoCompile	dynamic		perl		chapter6/Perl-5.8.0
	DoCompile	dynamic		*linuxthreads	chapter6/Linuxthreads-2.2.5
	DoCompile	dynamic		m4		chapter6/M4-1.4
	DoCompile	dynamic		texinfo		chapter6/Texinfo-4.2
	DoCompile	dynamic		autoconf	chapter6/Autoconf-2.53
	DoCompile	dynamic		automake	chapter6/Automake-1.6.3
	DoCompile	dynamic		bash		chapter6/Bash-2.05a
	DoCompile	dynamic		file		chapter6/File-3.39
	DoCompile	dynamic		libtool		chapter6/Libtool-1.4.2
	DoCompile	dynamic		bin86		chapter6/Bin86-0.16.3
	DoCompile	dynamic		bzip2		chapter6/Bzip2-1.0.2
	DoCompile	dynamic		ed		chapter6/Ed-0.2
	DoCompile	dynamic		kbd		chapter6/Kbd-1.06
	DoCompile	dynamic		diffutils	chapter6/Diffutils-2.8.1
	DoCompile	dynamic		e2fsprogs	chapter6/E2fsprogs-1.27
	DoCompile	dynamic		grep		chapter6/Grep-2.5
	DoCompile	dynamic		gzip		chapter6/Gzip-1.2.4a
	DoCompile	dynamic		man		chapter6/Man-1.5k
	DoCompile	dynamic		lilo		chapter6/Lilo-22.2
	DoCompile	dynamic		make		chapter6/Make-3.79.1
	DoCompile	dynamic		modutils	chapter6/Modutils-2.4.19
	DoCompile	dynamic		netkit-base	chapter6/Netkit-base-0.17
	DoCompile	dynamic		patch		chapter6/Patch-2.5.4
	DoCompile	dynamic		procinfo	chapter6/Procinfo-18
	DoCompile	dynamic		procps		chapter6/Procps-2.0.7
	DoCompile	dynamic		psmisc		chapter6/Psmisc-21
	DoCompile	dynamic		shadow		chapter6/Shadow-4.0.3
	DoCompile	dynamic		sysklogd	chapter6/Sysklogd-1.4.1
	DoCompile	dynamic		sysvinit	chapter6/Sysvinit-2.84
	DoCompile	dynamic		tar		chapter6/Tar-1.13
	DoCompile	dynamic		util-linux	chapter6/Util-linux-2.11u
	DoCompile	dynamic		lfs-bootscripts	chapter6/LFS-Bootscripts-1.10
	cp program/linux-2.4.19.$lfs_kernel.config $lfs_root/usr/src/
	DoCompile	dynamic		linux		chapter8/Linux-2.4.19
}

function main ()
{
	mkdir -p $lfs_root/{static,usr/src}

	DoOptimization
	DoPrecompilation

	rm -rf $lfs_root/usr/src/

	mkdir $lfs_root/static/tmp/
	cp -R $lfsinstall_swap/linuxfromscratch/lfs-commands/ $lfs_root/static/tmp/

	DoChroot chapter6/changing_ownership_lfs
	DoChroot chapter6/creating_directories
	DoChroot chapter6/mounting_proc
	DoChroot chapter6/creating_etc_mtab
	DoChroot chapter6/creating_bin_sh
	DoChroot chapter6/creating_passwd_group

	DoCompilation

	DoChroot chapter6/configuring_vim
	DoChroot chapter6/configuring_glibc
	DoChroot chapter6/configuring_dynamic_loader
	DoChroot chapter6/configuring_sysklogd
	DoChroot chapter6/configuring_shadow_password
	DoChroot chapter6/configuring_sysvinit
	DoChroot chapter6/configuring_keyboard
	DoChroot chapter6/creating_var_run
	DoChroot chapter6/creating_root_password
	DoChroot chapter7/configuring_setclock_script
	DoChroot chapter7/configuring_localnet_script
	DoChroot chapter7/creating_etc_hosts
	DoChroot chapter7/configuring_default_gateway
	DoChroot chapter7/creating_network_interface
	DoChroot chapter8/creating_etc_fstab
	#DoChroot chapter8/making_lfs_system_bootable
	DoChroot chapter9/the_end
	DoChroot chapter9/rebooting_system

cat > $lfs_root/etc/lfs << "EOF"
Linux From Scratch, release 4.0
       --build with lfs-install
EOF

	cp -R $lfsinstall_swap/linuxfromscratch/lfs-books/ $lfs_root/usr/share/doc/
	mv $lfs_root/usr/share/doc/lfs-books/ $lfs_root/usr/share/doc/lfs-book-4.0/

	echo "TODO"
	echo ". $LFS/etc/fstab"
	echo ". Lilo (MBR)"
	echo ". root password"
	echo ""
	echo "Happy hacking..."
}

main
