/*
	lfs-install - A install tool for `Linux From Scratch'
	Copyright (C) 2002  Daniel Baumann <danielbaumann@linuxmail.org>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdio.h>
#include<stdlib.h>

void display_usage(void);
void display_copyright(void);
void display_help(void);
void display_version(void);

void chapters(void);
void chapter3(void);
void chapter4(void);
void chapter5(void);
void chapter6_1(void);
void chapter6_2(void);
void chapter7(void);
void chapter8(void);

void download_packages(void);
void check_packages(void);
void partition_disk(void);
void format_partition(void);
void mount_partition(void);
void create_directories(void);
void copy_packages(void);
void precompile_bash(void);
void precompile_binutils(void);
void precompile_bzip2(void);
void precompile_diffutils(void);
void precompile_fileutils(void);
void precompile_gawk(void);
void precompile_gcc(void);
void precompile_grep(void);
void precompile_gzip(void);
void precompile_linux(void);
void precompile_make(void);
void precompile_patch(void);
void precompile_sed(void);
void precompile_sh_utils(void);
void precompile_tar(void);
void precompile_texinfo(void);
void precompile_textutils(void);
void create_passwd(void);
void create_group(void);
void mount_proc(void);
void create_bash_profile(void);
void enter_chroot(void);
void change_permissions(void);

int main(int argc, char *argv[])
{
	if ((argc<=1)||(argc>3))
	{
		display_usage();
		exit(EXIT_FAILURE);
	}

	if (strcmp(argv[1],"--copyright")==0)
	{
		display_copyright();
		exit(EXIT_SUCCESS);
	}

	if (((strcmp(argv[1],"-h")==0)||(strcmp(argv[1],"--help")==0)))
	{
		display_help();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--version")==0)
	{
		display_version();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapters")==0)
	{
		chapters();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter3")==0)
	{
		chapter3();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter4")==0)
	{
		chapter4();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter5")==0)
	{
		chapter5();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter6_1")==0)
	{
		chapter6_1();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter6_2")==0)
	{
		chapter6_2();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter7")==0)
	{
		chapter7();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--chapter8")==0)
	{
		chapter8();
		exit(EXIT_SUCCESS);
	}

	display_usage();
	exit(EXIT_FAILURE);
}

void display_usage(void)
{
	fprintf(stderr, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stderr, "Type `lfs-install --help' for details\n");
}

void display_copyright(void)
{
	fprintf(stdout, "Copyright (C) 2002  Daniel Baumann <danielbaumann@linuxmail.org>\n");
	fprintf(stdout, "lfs-install comes with ABSOLUTELY NO WARRANTY; for details see `COPYING'.\n");
	fprintf(stdout, "This is free software, and you are welcome to redistribute it\n");
	fprintf(stdout, "under certain conditions; see `COPYING' for details.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "This program depends on `Linux From Scratch', version 3.3\n");
	fprintf(stdout, "Copyright (c) 1999-2002, Gerard Beekmans\n");
}

void display_help(void)
{
	fprintf(stdout, "lfs-install - A install tool for `Linux From Scratch'\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Arguments:\n");
	fprintf(stdout, "  --chapters                           Do all chapters of LFS (recommendet)\n");
	fprintf(stdout, "  --chapter3                           Do chapter 3 of LFS\n");
	fprintf(stdout, "  --chapter4                           Do chapter 4 of LFS\n");
	fprintf(stdout, "  --chapter5                           Do chapter 5 of LFS\n");
	fprintf(stdout, "  --chapter6_1                         Do chapter 6 of LFS to chroot\n");
	fprintf(stdout, "  --chapter6_2                         Do chapter 6 of LFS from chroot\n");
	fprintf(stdout, "  --chapter7                           Do chapter 7 of LFS\n");
	fprintf(stdout, "  --chapter8                           Do chapter 8 of LFS\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "  --copyright                          Display the copyright of this program\n");
	fprintf(stdout, "  -h, --help                           Display this information\n");
	fprintf(stdout, "  --version                            Display the version of this program\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "For bug reporting, please write to:\n");
	fprintf(stdout, "Daniel Baumann <danielbaumann@linuxmail.org>\n");
}

void display_version(void)
{
	fprintf(stdout, "0.0.1\n");
}

void chapters(void)
{
	chapter3();
	chapter4();
	chapter5();
	chapter6_1();
	chapter6_2();
	chapter7();
	chapter8();
}

void chapter3(void)
{
	download_packages();
	check_packages();
}

void chapter4(void)
{
	partition_disk();
	format_partition();
	mount_partition();
}

void chapter5(void)
{
	create_directories();
	copy_packages();
	precompile_bash();
	precompile_binutils();
	precompile_bzip2();
	precompile_diffutils();
	precompile_fileutils();
	precompile_gawk();
	precompile_gcc();
	precompile_grep();
	precompile_gzip();
	precompile_linux();
	precompile_make();
	precompile_patch();
	precompile_sed();
	precompile_sh_utils();
	precompile_tar();
	precompile_texinfo();
	precompile_textutils();
	create_passwd();
	create_group();
	mount_proc();
}

void chapter6_1(void)
{
	create_bash_profile();
	enter_chroot();
}

void chapter6_2(void)
{
	change_permissions();
}

void chapter7(void)
{
}

void chapter8(void)
{
}

void download_packages()
{
	char download_packages[100];
	fprintf(stdout, "Download packages\n");
	sprintf(download_packages, "cd commands/chapter3 && ./download_packages");
	system(download_packages);
}

void check_packages()
{
	char check_packages[100];
	fprintf(stdout, "Check packages\n");
	sprintf(check_packages, "cd commands/chapter3 && ./check_packages");
	system(check_packages);
}

void partition_disk()
{
	char partition_disk[100];
	char disk[10];
	fprintf(stdout, "Partition disk\n");
	fprintf(stdout, "Enter disk name (e.g. /dev/hda): ");
	scanf("%s", &disk);
	sprintf(partition_disk, "fdisk %s", disk);
	system(partition_disk);
}

void format_partition()
{
	char format_partition[100];
	char partition[10];
	fprintf(stdout, "Format partition\n");
	fprintf(stdout, "Enter partition name (e.g. /dev/hda1): ");
	scanf("%s", &partition);
	sprintf(format_partition, "mkfs -L LFS %s", partition);
	system(format_partition);
}

void mount_partition()
{
	char mount_partition[100];
	char partition[10];
	fprintf(stdout, "Mount partition\n");
	fprintf(stdout, "Enter partition name (e.g. /dev/hda1): ");
	scanf("%s", &partition);
	sprintf(mount_partition, "mount %s $LFS", partition);
	system(mount_partition);
}

void create_directories()
{
	char create_directories[100];
	fprintf(stdout, "Create directories\n");
	sprintf(create_directories, "cd commands/chapter5 && ./create_directories");
	system(create_directories);
}

void copy_packages()
{
	char copy_packages[100];
	fprintf(stdout, "Copy packages\n");
	sprintf(copy_packages, "cd commands/chapter5 && ./copy_packages");
	system(copy_packages);
}

void precompile_bash()
{
	char precompile_bash[100];
	fprintf(stdout, "Precompile bash\n");
	sprintf(precompile_bash, "cd commands/chapter5 && ./precompile_bash");
	system(precompile_bash);
}

void precompile_binutils(void)
{
	char precompile_binutils[100];
	fprintf(stdout, "Precompile binutils\n");
	sprintf(precompile_binutils, "cd commands/chapter5 && ./precompile_binutils");
	system(precompile_binutils);
}

void precompile_bzip2(void)
{
	char precompile_bzip2[100];
	fprintf(stdout, "Precompile bzip2\n");
	sprintf(precompile_bzip2, "cd commands/chapter5 && ./precompile_bzip2");
	system(precompile_bzip2);
}

void precompile_diffutils(void)
{
	char precompile_diffutils[100];
	fprintf(stdout, "Precompile diffutils\n");
	sprintf(precompile_diffutils, "cd commands/chapter5 && ./precompile_diffutils");
	system(precompile_diffutils);
}

void precompile_fileutils(void)
{
	char precompile_fileutils[100];
	fprintf(stdout, "Precompile fileutils\n");
	sprintf(precompile_fileutils, "cd commands/chapter5 && ./precompile_fileutils");
	system(precompile_fileutils);
}

void precompile_gawk(void)
{
	char precompile_gawk[100];
	fprintf(stdout, "Precompile gawk\n");
	sprintf(precompile_gawk, "cd commands/chapter5 && ./precompile_gawk");
	system(precompile_gawk);
}

void precompile_gcc(void)
{
	char precompile_gcc[100];
	fprintf(stdout, "Precompile gcc\n");
	sprintf(precompile_gcc, "cd commands/chapter5 && ./precompile_gcc");
	system(precompile_gcc);
}

void precompile_grep(void)
{
	char precompile_grep[100];
	fprintf(stdout, "Precompile grep\n");
	sprintf(precompile_grep, "cd commands/chapter5 && ./precompile_grep");
	system(precompile_grep);
}

void precompile_gzip(void)
{
	char precompile_gzip[100];
	fprintf(stdout, "Precompile gzip\n");
	sprintf(precompile_gzip, "cd commands/chapter5 && ./precompile_gzip");
	system(precompile_gzip);
}

void precompile_linux(void)
{
	char precompile_linux[100];
	fprintf(stdout, "Precompile linux\n");
	sprintf(precompile_linux, "cd commands/chapter5 && ./precompile_linux");
	system(precompile_linux);
}

void precompile_make(void)
{
	char precompile_make[100];
	fprintf(stdout, "Precompile make\n");
	sprintf(precompile_make, "cd commands/chapter5 && ./precompile_make");
	system(precompile_make);
}

void precompile_patch(void)
{
	char precompile_patch[100];
	fprintf(stdout, "Precompile patch\n");
	sprintf(precompile_patch, "cd commands/chapter5 && ./precompile_patch");
	system(precompile_patch);
}

void precompile_sed(void)
{
	char precompile_sed[100];
	fprintf(stdout, "Precompile sed\n");
	sprintf(precompile_sed, "cd commands/chapter5 && ./precompile_sed");
	system(precompile_sed);
}

void precompile_sh_utils(void)
{
	char precompile_sh_utils[100];
	fprintf(stdout, "Precompile sh-utils\n");
	sprintf(precompile_sh_utils, "cd commands/chapter5 && ./precompile_sh_utils");
	system(precompile_sh_utils);
}

void precompile_tar(void)
{
	char precompile_tar[100];
	fprintf(stdout, "Precompile tar\n");
	sprintf(precompile_tar, "cd commands/chapter5 && ./precompile_tar");
	system(precompile_tar);
}

void precompile_texinfo(void)
{
	char precompile_texinfo[100];
	fprintf(stdout, "Precompile texinfo\n");
	sprintf(precompile_texinfo, "cd commands/chapter5 && ./precompile_texinfo");
	system(precompile_texinfo);
}

void precompile_textutils(void)
{
	char precompile_textutils[100];
	fprintf(stdout, "Precompile textutils\n");
	sprintf(precompile_textutils, "cd commands/chapter5 && ./precompile_textutils");
	system(precompile_textutils);
}

void create_passwd(void)
{
	char create_passwd[100];
	fprintf(stdout, "Create /etc/passwd\n");
	sprintf(create_passwd, "cd commands/chapter5 && ./create_passwd");
	system(create_passwd);
}

void create_group(void)
{
	char create_group[100];
	fprintf(stdout, "Create /etc/group\n");
	sprintf(create_group, "cd commands/chapter5 && ./create_group");
	system(create_group);
}

void mount_proc(void)
{
	char mount_proc[100];
	fprintf(stdout, "Mount /proc\n");
	sprintf(mount_proc, "cd commands/chapter5 && ./mount_proc");
	system(mount_proc);
}

void create_bash_profile(void)
{
	char create_bash_profile[100];
	fprintf(stdout, "Create /root/.bash_profile\n");
	sprintf(create_bash_profile, "cd commands/chapter6 && ./create_bash_profile");
	system(create_bash_profile);
}

void enter_chroot(void)
{
	char enter_chroot[100];
	fprintf(stdout, "Enter chroot\n");
	sprintf(enter_chroot, "cd commands/chapter6 && ./enter_chroot");
	system(enter_chroot);
}

void change_permissions(void)
{
	char change_permissions[100];
	fprintf(stdout, "Change_permissions\n");
	sprintf(change_permissions, "cd /lib/lfs-install/chapter6 && ./change_permissions");
	system(change_permissions);
}
