
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import gtk
import view
import os
import ioman
import diacanvas
import pickle
import gc

class Gui(gtk.Window):
    def __init__(self, app):
        self.app = app
        gtk.Window.__init__(self)
        self.connect('destroy', app.Quit)
        self.set_title('GraphTool-'+app._VERSION_)
        self.set_default_size(400, 400)

        #config
        self.modules_path_dict={}
        self.load_conf()
        self.accelgroup=None
        self.file_selector=None
        self.active_button=None
        self.graph=None
        self.menubar=None
        self.file_new_menu=None
        self.types_remove_menu=None
        

        self.sb = gtk.Statusbar()
        self.sb.set_size_request(600,20)
#        self.sb.show()

        self.build_menubar()

        # pour mettre la toolbar + view
        self.vbox = gtk.VBox()

        box = gtk.VBox()
        box.pack_start(self.menubar, gtk.FALSE, gtk.FALSE, 0)
        box.pack_start(self.vbox)
        box.pack_start(self.sb, gtk.FALSE, gtk.FALSE, 0)
        self.add(box)
        self.write_msg("Choose file to open/create a graph")
        self.show_all()


#########################################################################################
#  Methodes de chargement/sauvegarde de la configuration de l'interface graphique        
#

    #chargement
    def load_conf(self, filename="modules.dat"):
        try:
            file=open(filename,'r')
            self.modules_path_dict=pickle.load(file)
            file.close()
        except:
            self.modules_path_dict={}
                
        
    #sauvegarde
    def save_conf(self, filename="modules.dat"):
        file=open(filename,'w')
        pickle.dump(self.modules_path_dict,file)
        file.close()

        
#########################################################################################
#  Methodes de creation des divers elements de l'interface graphique        
#

    #generation de la bare d'outils
    def build_toolbar(self):
        print "building toolbar..."
        self.tb = gtk.Toolbar()
        self.tb.set_size_request(600,40)
        #on ajoute les boutons
        for sublist in self.graph.get_toolbar():
            img=gtk.Image()
            img.set_from_file(sublist[1])
            img.show()
            #self.tb.append_item(None, None, None, img, self.view.set_add_node_mode, sublist[2])
            self.tb.append_element(gtk.TOOLBAR_CHILD_TOGGLEBUTTON,
                                   None,
                                   None,
                                   None,
                                   None,
                                   img,
                                   self.generic_toggle_button_hook,
                                   sublist)
        #on ajoute un separateur
        self.tb.append_space()
        #on ajoute le bouton remove
        imgremove=gtk.Image()
        imgremove.set_from_file('trash.png')
        self.tb.append_item(None, None, None, imgremove, self.remove_object_hook)
        self.tb.show()
        self.vbox.pack_start(self.tb, gtk.FALSE, gtk.FALSE, 0)
#        self.toolbar_box.pack_start (self.tb, gtk.FALSE, gtk.FALSE, 0)
#        self.toolbar_box.show()
        print "toolbar built."

    #cree la vue
    #precond: self.graph initialise 
    def build_view(self):
        print "building view..."
        self.view = view.view(self, canvas=self.graph, aa=1)        
        self.view.show()
        #self.view_box.pack_start(self.view)
        self.vbox.pack_start(self.view)
        #self.view_box.show()
        print "view built."
    

    #genere un menu a partir des types de graphes connus 
    def build_menubar(self):
        menubar = gtk.MenuBar()
        self.menubar = menubar
#        self.accelgroup = gtk.AccelGroup()
#        self.win.add_accelerator(self.accelgroup)

        filemenuitem = gtk.MenuItem('_File')
        filemenu = gtk.Menu()
        menuitem = gtk.MenuItem('New _Window')
        menuitem.connect('activate', self.app.NewGui)
        menuitem.set_data('ident', 'file_new_window')
        filemenu.append(menuitem)
        self.file_new_menu = gtk.MenuItem('_New')
        filemenu.append(self.file_new_menu)
        menuitem = gtk.MenuItem('_Open')
        menuitem.connect('activate', self.menu_item_cb)
        menuitem.set_data('ident', 'file_open')
        filemenu.append(menuitem)
        menuitem = gtk.MenuItem('_Save')
        menuitem.connect('activate', self.menu_item_cb)
        menuitem.set_data('ident', 'file_save')
        filemenu.append(menuitem)
        menuitem = gtk.MenuItem('_Quit')
        menuitem.connect('activate', self.menu_item_cb)
        menuitem.set_data('ident', 'file_quit')
        filemenu.append(menuitem)
        filemenuitem.set_submenu(filemenu)
        menubar.append(filemenuitem)

        typesmenuitem = gtk.MenuItem('_Types')
        typesmenu = gtk.Menu()
        menuitem = gtk.MenuItem('_Add')
        menuitem.connect('activate', self.menu_item_cb)
        menuitem.set_data('ident', 'types_add')
        typesmenu.append(menuitem)
        self.types_remove_menu = gtk.MenuItem('_Remove')
        typesmenu.append(self.types_remove_menu)
        typesmenuitem.set_submenu(typesmenu)
        menubar.append(typesmenuitem)

        self.update_menubar()


#########################################################################################
#  Methodes de mise a jour des divers elements de l'interface graphique        
#

    #mets a jour la barre de menu (apres ajout d'un type par ex)
    def update_menubar(self):
        filenewsubmenu = gtk.Menu()
        typesremovesubmenu = gtk.Menu()
        for item in self.modules_path_dict.keys():
            filenewitem = gtk.MenuItem(item)
            filenewitem.connect('activate', self.new_graph_cb)
            filenewitem.set_data('classname', item)
            filenewsubmenu.append(filenewitem)
            typesremoveitem = gtk.MenuItem(item)
            typesremoveitem.connect('activate', self.remove_type_cb)
            typesremoveitem.set_data('classname', item)
            typesremovesubmenu.append(typesremoveitem)
        self.file_new_menu.set_submenu(filenewsubmenu)
        self.types_remove_menu.set_submenu(typesremovesubmenu)
        self.show_all()

    #ecrit un message dans la toolbar    
    def write_msg(self, msg):
        if hasattr(self,'sb'):
            id=self.sb.get_context_id("pile")
            self.sb.pop(id)
            self.sb.push(id,msg)


    #remet la toolbar en mode normal
    def tb_normal_mode(self):
        if self.active_button != None:
            self.active_button.set_active(False)
                      
    #remet a leur etat initial la vue les boutons et detruit le graphe 
    def reset(self):
        #dehors la toulbar 
        self.vbox.remove(self.tb)
        self.tb.hide
        self.tb=None
        #detruit la vue
        self.vbox.remove(self.view)
        self.view.set_property('canvas',None)
        self.view=None
        #detruit le graphe
        self.graph.delete()
        self.graph=None

    #indique si l'interface a ete utilisee ou non
    def used(self):
        return self.graph


#########################################################################################
#  Methodes declenchees par une action sur la barre de cboutons (toolbar)        
#


    #methode appelee losque l'utilisateur clique sur un des togglebuttons
    def generic_toggle_button_hook(self, source, button_info):
        action_type=button_info[0]
        graph_cb=button_info[2]
        if source.get_active():
            if self.active_button==None:
                self.active_button=source
            else:
                self.view.set_normal_mode()
                self.active_button.set_active(False)
                self.active_button=source
            if action_type=='IN':
                self.view.set_add_node_mode(graph_cb)
            elif action_type=='IE':
                self.view.set_add_edge_mode(graph_cb)
        else:
            self.view.set_normal_mode()
            self.active_button=None


    #fonction apelee lorsque l'utilisateur clique sur le btn supprimer
    def remove_object_hook(self, source):
        if self.active_button!=None:
                self.active_button.set_active(False)
        self.view.delete_selection()



#########################################################################################
#  Dispatcheurs de la barre de menu        
#


    #dispatcheur de tout ce qui ne change pas en fonction des types connus
    def menu_item_cb(self, menuitem):
        ident = menuitem.get_data('ident')
        if ident == 'file_new_window':
            self.app.NewGui()
        elif ident == 'file_open':
            self.file_open()
        elif ident == 'file_save':
            self.file_save()
        elif ident == 'file_export':
            self.file_export()
        elif ident == 'file_quit':
            self.app.Quit()
        elif ident == 'types_add':
            self.types_add()
        else:
            print "NOT YET IMPLEMENTED:"+ident

    #dispatcheur special pour file/new
    def new_graph_cb(self, menuitem):
        self.file_new(menuitem.get_data('classname'))    
    def new_graph_cb_bak (self, view, class_key_index, widget):
        self.file_new(self.modules_path_dict.keys()[class_key_index])


    #dispatcheur special pour types/remove
    def remove_type_cb(self, menuitem):
        self.types_remove(menuitem.get_data('classname'))


#########################################################################################
#  Methodes appeles directement par les dispatcheurs        
#


    #charge un graphe (file open)        
    def file_open(self):
        #on vire le message de la barre d'outils
        self.sb.pop(0)
        #creation du selecteur
        self.file_selector=gtk.FileSelection('Pick a graphXML file, joe...')
        self.file_selector.ok_button.connect ( 'clicked', self.file_to_load_selected,)
        self.file_selector.cancel_button.connect ( 'clicked', self.fs_canceled,)
        #affichage
        self.file_selector.show()

    #sauve en svg
    def file_export (self):
        self.sb.pop(0)
        filesel = gtk.FileSelection('Export graph to SVG file')
	filesel.set_modal(True)
	filesel.set_filename('export.svg')
        response = filesel.run()
	filesel.hide()
	if response == gtk.RESPONSE_OK:
	    filename = filesel.get_filename()
	    if filename and len(filename) > 0:
		self.filename = filename
		#log.debug('Exporting SVG image to: %s' % filename)
		canvas = self.graph
		export = diacanvas.ExportSVG()
		try:
		    export.render (canvas)
		    export.save(filename)
		except Exception, e:
		    #log.error('Error while saving model to file %s: %s' % (filename, e))
                    pass


    #sauve un graphe (file save)
    def file_save(self):
         #on vire le message de la barre d'outils
         self.sb.pop(0)
         #creation du selecteur
         self.file_selector=gtk.FileSelection('Type in your file name for saving, joe...')
         self.file_selector.ok_button.connect ( 'clicked', self.file_to_save_selected,)
         self.file_selector.cancel_button.connect ( 'clicked', self.fs_canceled,)
         #affichage
         self.file_selector.show()

         
      
    #creation de graphe
    def file_new(self, class_name):        
        #repartons sur une base saine
        if self.used():
            self.reset()
        #on vire le message de la barre d'outils
        self.sb.pop(0)
        #on sauve le repertoire courant
        cur_dir_bkup=os.getcwd()
        #on va dans le rep du module qui definit la classe choisie
        os.chdir(self.modules_path_dict[class_name])
        #on genere la bonne invocation (par convention, nom module = nom de classe...)
        invocation_import='import '+class_name
        #and now ladies and gents, the momment you were all expecting for
        exec(invocation_import)
        #__import__(class_name)
        self.graph=eval(class_name+'.'+class_name+'()')
        #self.graph=eval(class_name+'.'+class_name+'()')
        #on revient la ou on etait
        os.chdir(cur_dir_bkup)
        #on peut generer la barre d'outils, l'instance du graphe
        #nous donnera les meta-renseignements qu'il faut
        self.build_toolbar()
        self.build_view()
        
    def types_add(self):
        #on vire le message de la barre d'outils
        self.sb.pop(0)
        #creation du selecteur
        self.file_selector=gtk.FileSelection('Pick a class...')
        self.file_selector.ok_button.connect ( 'clicked', self.type_to_add_selected,)
        self.file_selector.cancel_button.connect ( 'clicked', self.fs_canceled,)
        #affichage
        self.file_selector.show()


    def types_remove(self, class_name):
        del self.modules_path_dict[class_name]
        self.save_conf()
        self.update_menubar()
        
#########################################################################################
#  Methodes auxiliaires des precedentes        
#

    #methode apellee apres clic cancel sur le selecteur
    def fs_canceled(self, source):
        #on cache la fenetre de selection de fichier
        self.file_selector.hide()
        #destruction du selecteur
        del self.file_selector
        self.file_selector=None




    #methode apellee apres clic ok selecteur fichier xml a charger
    def file_to_load_selected(self, source):
        #repartons sur une base saine 
        if self.used():
            self.reset()
        #on cache la fenetre de selection de fichier
        self.file_selector.hide()
        #on recupere le nom du fichier a parser
        xml_file_full_path=self.file_selector.get_filename()
        #destruction du selecteur
        del self.file_selector
        self.file_selector=None
        #and now ladies and gents, the momment you were all expecting for
        self.graph=ioman.from_file(xml_file_full_path, self.modules_path_dict)
        #on peut generer la barre d'outils, l'instance du graphe
        #nous donnera les meta-renseignements qu'il faut
        self.build_toolbar()
        #on construit enfin la vue
        self.build_view()




    #methode apellee apres clic ok selecteur fichier xml
    def file_to_save_selected(self, source):
        #on cache la fenetre de selection de fichier
        self.file_selector.hide()
        #on recupere le nom du fichier a parser
        save_path=self.file_selector.get_filename()
        #destruction du selecteur
        del self.file_selector
        self.file_selector=None
        #flushons mes amis...
        ioman.to_file(save_path,self.graph)


    #methode apellee apres clic ok selecteur classe python
    def type_to_add_selected(self, source):
        #on cache la fenetre de selection de fichier
        self.file_selector.hide()
        #on recupere le nom du fichier a parser
        module_path=self.file_selector.get_filename()
        splitted_path=os.path.split(module_path)
        graph_module_dir=splitted_path[0]
        graph_module_name=splitted_path[1]       
        #le nom du module est le nom du fichier sans l'eventuelle extension
        if graph_module_name[-3:] == '.py':
            graph_module_name = graph_module_name[:-3]
        #destruction du selecteur
        del self.file_selector
        self.file_selector=None
        self.modules_path_dict[graph_module_name]=graph_module_dir
        self.save_conf()
        self.update_menubar()



#that's all folks.
#fonction qui termine la boucle gtk
def mainquit (*arg):
    gtk.main_quit()
    
        
