#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from Graph import *
from UNode import *
from Edge import *


class UGraph (Graph):
    def __init__(self):
        Graph.__init__(self)

    def make_node (self):
        name = str (self._counter_name)
        new_node = UNode (self, name)
        self._counter_name = self._counter_name + 1
        self.add_node (new_node)
        return new_node

    def make_edge (self):
        new_edge = Edge (self)
        self.add_arc (new_edge)
        return new_edge

    def get_toolbar (self):
        tb = Graph.get_toolbar (self)
        #pour l'icne des Edges, on met  jour la toolbar
        tb = replace_toolbar_item (tb, 'IE','add_edge.png',self.make_edge)
        return tb
