#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from Petri_Node import *
import diacanvas as dia
import pango


class Place (Petri_Node):
    def __init__(self, graph, name):
        Petri_Node.__init__(self, graph, name)
        self.tokens = 0
        self.add_accessor ('Tokens', self.get_tokens, self.set_tokens, int)
        
    #On ajoute l'affichage du nombre de tokens dans
    #les places 
    def init_shapes (self):
        #init de l'ellipse
        Node.init_shapes (self)
        self.set (height = 45, width = 45)
        self._shapes[0].ellipse (center=(self.width/2, self.height/2),
                                 width=self.width-16,
                                 height=self.height-16)
        #ajout du nombre de tokens au milieu de l'ellipse
        self._shapes.append (dia.shape.Text ())
	font = pango.FontDescription('sans 12')
	self._shapes[1].set_font_description(font)
	self._shapes[1].set_text_width(20)
        self._shapes[1].set_max_height(20)
        self._shapes[1].set_pos ((self.width/2.5, self.height/3.5))
        self._shapes[1].set_text ('0')
        self.init_labels ()
        
    def delete (self):
      #suppression d'une place peut invalider une
      #transition
      if self.tokens > 0:
          for trans in self.get_successors():
              trans.decr_validating_places ()
      Node.delete (self)

    def get_tokens (self):
        return self.tokens

    def set_tokens (self, number):
        self.tokens = number
        if number > 0:
            for trans in self.get_successors ():
                trans.incr_validating_places ()
        #raffrachir la vue
        self.request_update ()

    def decr_tokens (self):
        self.tokens = self.tokens - 1

    def incr_tokens (self):
        self.tokens = self.tokens + 1

    def on_update (self, affine):
        Node.on_update (self, affine)
        self._shapes[1].set_text (str(self.get_tokens()))
        
