#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from Node import *
import diacanvas as dia
import pango

class Petri_Node(Node):
    def __init__(self, graph, name):
        Node.__init__(self, graph, name)
        #Un graphe de Ptri tant au minimum constitu de
        #deux places et d'une transition, un noeud
        #qui n'a encore aucune connexion ne peut
        #constituer une cc, comme dans le cas gnral
        #un noeud de Ptri n'appartient donc  aucune cc
        # sa cration.
        #level = niveau de la auquel le noeud appartient
        #number = numro du noeud, correspond  sa place
        #dans le niveau
        self._cc = None
        self._level = None
        self._number = None

    def init_labels (self):
        #ajout de l'tiquette
        self._label_index = len (self._shapes)
        self._shapes.append (dia.shape.Text ())
	font = pango.FontDescription('sans 12')
	self._shapes[self._label_index].set_font_description(font)
	self._shapes[self._label_index].set_text_width(20)
        self._shapes[self._label_index].set_max_height(20)
        self._shapes[self._label_index].set_pos ((self.width-8,
                                                  self.height/2))
        self._shapes[self._label_index].set_text ('-')

    def update_labels (self):
        num = self.get_number ()
        if num is None:
            num = '-'
        self._shapes[self._label_index].set_text (str (num))
          
    def set_placement (self, cc, level, number):
        self._cc = cc
        self._level = level
        self._number = number

    def get_placement (self):
        return [self._cc, self._level, self._number]

    def set_level (self, level):
        self._level = level

    def set_cc (self, cc):
        self._cc = cc

    def set_number (self, num):
        self._number = num

    def get_level (self):
        return self._level
    
    def get_cc (self):
        return self._cc
    
    def get_number (self):
        return self._number

         
    
    
