from Graph import *
from Place import *
from Transition import *
from Petri_Arc import *

class Petri_Net (Graph):

    def __init__(self):
        Graph.__init__(self)
        #liste des composantes connexes du graphe
        #une entre = une cc
        #une cc = [[noeuds de niveau 1], [noeuds de niveau 2], ...]
        self._cc = []
        #liste ordonne des id des arcs retour du graphe
        self._return_arcs = []
        self.add_user_method ('Animate', self.animate)
        self.add_user_method ('Animate all', self.animate_all)
      
    
    #publiques

    def get_marking (self):
        pass
    
    def make_place (self):
        return self.make_node ('Place')
        
    def make_trans (self):
        return self.make_node ('Trans')

    def make_node (self, type_node):
        name = str (self._counter_name)
        new_node = None
        if (type_node is 'Place'):
            new_node = Place (self, name)
        else:
            new_node = Transition (self, name)
                              
        self._counter_name = self._counter_name + 1
        self.add_node (new_node)
        return new_node

    def remove_node (self, node):
        num_cc = node.get_cc ()
        level_node = node.get_level ()
        #print "num_cc :", num_cc
        try:
            cc_node = self._cc[num_cc]
            #print "cc_node",cc_node
            cc_node[level_node].remove (node)
        except:
            pass
        Graph.remove_node (self, node)

    def make_arc (self):
        new_arc = Petri_Arc (self)
        self.add_arc (new_arc)
        return new_arc        

    # dtruire ->placer update_labels dans on_update
    def update_all_labels (self):
        for nk in self._nodes:
            self._nodes[nk].update_labels ()
        self.update_now ()

    def add_arc (self, arc):
        print (arc)
        self._arcs[id (arc)] = arc

    def number_nodes (self, arc):
        print "number_nodes"
        first = arc.get_first_node ()
        second = arc.get_second_node ()
        print "FIRST : ",first
        print "SECOND : ",second
        
        #CAS N1: Nvelle cc
        #-------
        #les deux noeuds n'ont aucune connexion : nvelle cc
        #aucune connexion <=> number = None
        if (first.get_number () is None) and \
           (second.get_number () is None):
            print "case 1"
            self.nn_first_case (first, second) 

        #CAS N2: Ajout d'un noeud non connect en aval d'une cc
        #--------
        elif (first.get_number () != None) and \
             (second.get_number () is None):
            print "case 2"
            self.nn_second_case (first, second)
           
        #CAS N3 : Ajout d'un noeud non connect en amont d'une cc
        #--------
        elif (first.get_number () is None) and \
             (second.get_number () != None):
            print "case 3"
            self.nn_third_case (first, second)

        #CAS N4 : les deux noeuds ont dj un placement
        #---------
        else:
            "print case 4"
            #cas n1 : les deux noeuds appartiennent  la mme cc
            #--------
            first_cc_num = first.get_cc ()
            second_cc_num = second.get_cc ()

            if first_cc_num == second_cc_num:
                           self.same_cc_arc_adding (first, second, arc)

            #autres cas : fusion de deux cc
            #------------
            else:
                self.cc_fusion (first, second)
        
    def same_cc_arc_adding (self, first, second, arc):
        print "arc adding"
        first_level =  first.get_level ()
        second_level = second.get_level ()
        #si niveau first < niveau second => nouvel arc retour
        if first_level < second_level :
            self._return_arcs.append (id (arc))
            self._return_arcs.sort ()
              
    def cc_fusion (self, first, second):
        print "case 4-2, cc_fusion"
        first_level = first.get_level ()
        second_level = second.get_level ()
        second_cc_num = second.get_cc ()
        print "here ?"
                
        #CAS N1 : niveau first <= niveau second - 1
        #---------
        if (first_level >= second_level - 1):
            print "case 4-1"
            self.ccf_concat_same_level (first, second)

        #CAS N2 : niveau first > niveau second
        #---------
        else:
            print "4-2 else"
            #correspond  une fusion en amont,
            #dcalage : niveau de second = niveau de first + 1
            #mme dcalage pour les successeurs de second
            #fusion des niveaux 
            first_level = first.get_level ()
            start_level = first_level + 1
            self.shift_level_down (second, start_level)
            print "after shift"
            self.ccf_concat_same_level (first, second)
            print "after concat same"

        del self._cc[second_cc_num]

    def ccf_concat_same_level (self, first, second):
        print "same level"
        #aucun dcalage de niveau  faire,
        #on fusionne les niveaux des deux cc dans
        #la cc de first
        #on effectue le changement des num_cc des noeuds de la 2nde cc,
        #et la renumrotation de la cc au fur et  mesure de la fusion
        #on supprime la cc de second

        first_placement = first.get_placement ()
        second_placement = second.get_placement ()        
        first_cc_num = first_placement[0]
        second_cc_num = second_placement[0]
        
        first_level_num = first_placement[1]
        second_level_num = second_placement[1]
        
        first_cc = self._cc[first_cc_num]
        second_cc = self._cc[second_cc_num]
        
        #on initialise la numrotation des places et des trans
        next_place_number = self.get_next_number (first_cc_num, 0)
        next_trans_number = self.get_next_number (first_cc_num, 1)
        
        indexes = range (len (second_cc))
        for num_level in indexes:
            if "on est dans un niveau pair" :
                next_place_number = self.fusion_level (first,
                                                       second_cc,
                                                       num_level,
                                                       next_place_number)
            else:
                next_trans_number = self.fusion_level (first,
                                                       second_cc,
                                                       num_level,
                                                       next_trans_number)
                
    def fusion_level (self, first, second_cc, num_level, next_number):
        print "fusion level"
        first_cc_num = first.get_cc ()
        print "ou ?"
        first_cc = self._cc[first_cc_num]
        
        #si la cc de first possde moins de niveau que la
        #second cc
        if num_level >= len (first_cc):
            first_cc.append ([])

        #actualisation des numros des nodes de la premire cc
        #une fois passs les deux premiers niveaux
        if (num_level != 0) and (num_level != 1):
            for node in first_cc[num_level]:
                node.set_number (next_number)
                next_number = next_number + 1
                     
        for node in second_cc[num_level]:
            node.set_cc (first_cc_num)
            node.set_number (next_number)
            first_cc[num_level].append (node)
            next_number = next_number + 1
        return next_number
         
    def update_numbers (self, num_cc, from_num_level, next_number):
        print "update numbers"
        print "level : ", from_num_level
        print "deb number : ",next_number
        cc = self._cc[num_cc]
        i = from_num_level + 2
        print "bef while i : ",i
        while i < len (cc):
            print "cc : ",cc
            for node in cc[i]:
                node.set_number (next_number)
                next_number = next_number + 1
            i = i + 2
            print "next_level : ", i
        
        for level in cc:
            print "level : ",level
            if (len (level)>0):
                for node in level:
                    print "num node : ", node.get_number ()
            
    def number_cc (self, num_cc):
        print "number cc"
        #on numrote les places
        cc = self._cc[num_cc]
        print "cc : ", cc
        num = 0
        for place in cc[0]:
            place.set_number (num)
            num = num + 1
        self.update_numbers (num_cc, 0, num)

        #on numrote les transitions
        num = 0
        for trans in cc[1]:
            trans.set_number (num)
            num = num + 1
        self.update_numbers (num_cc, 1, num)
            
            
    def get_next_number (self, num_cc, num_level):
        print "get_next_number"
        cc = self._cc[num_cc]
        #nouveau niveau
        if num_level >= len (cc):
            print "new_level"
            cc.append ([])
            return self.get_next_number (num_cc, num_level - 2)
        level = cc[num_level]
        if len (level) > 0:
            print "level : ",level
            last_number = level[-1].get_number ()
            return (last_number + 1)
        #1er niveau vide, place de num 0
        else:
            return 0
            
    
    def shift_level_down (self, from_node, from_level):
        print ("shift")
        num_cc_node = from_node.get_cc ()
        cc_node = self._cc[num_cc_node]
        level_node = from_node.get_level ()
        #on dcale le noeud dans la matrice de la cc
        cc_node[level_node].remove (from_node)
        new_level_node = from_level
        from_node.set_level (new_level_node)
        if new_level_node >= len (cc_node):
            cc_node.append ([])
        cc_node[new_level_node].append (from_node)

        #on applique les mmes modifications aux successeurs
        #on rappelle qu'un noeud ne peut avoir de successeurs
        #dans son niveau
        print "out_edges form_node :", from_node.get_out_edges ()
        if (len (from_node.get_out_edges ())>0):
            for arc in from_node.get_out_edges ():
                #on saute les arcs retours
                if id (arc) in self._return_arcs:
                    continue
                else:
                    next_level = new_level_node + 2
                    print "end shift"
                    self.shift_level_down (arc.get_second_node (),
                                           next_level)
        else:
            return

    def nn_first_case (self, first, second):
        print "first case"
        cc = []
        first_number = 0
        second_number = 0

        if (type(first) is Place):
            print "case 1, place-trans"
            #la place est la premire (num = 0) du premier niveau,
            #la transition est la premire (num = 0) du second niveau
            cc.append ([first,])
            cc.append ([second,])
            first_level = 0
            second_level = 1
        else:
            print "case 2, trans-place"
            #la transition est la premire du second niveau,
            #la place est la premire du 3me niveau,
            #le premier niveau est vide.
            cc.append([])
            cc.append([first,])
            cc.append([second,])
            first_level = 1
            second_level = 2
                
        num_cc = len (self._cc)

        #on dit aux noeuds  quel emplacement ils appartiennent
        #(cf classe Petri_Node)
        first.set_placement (num_cc, first_level, first_number)
        second.set_placement (num_cc, second_level, second_number)

        print "cc, apres case 1 ", cc
        #on ajoute la nouvelle cc  la liste des cc, self._cc
        self._cc.append (cc)

    def nn_second_case (self, first, second):
        print "second case"
        #insertion d'un noeud non encore connect  une cc
        #le niveau du second noeud est alors 
        #celui du premier noeud + 1

        #le numro du second noeud correspond au numro + 1 du
        #dernier noeud du niveau dans lequel il est insrer

        #s'il y a des noeuds de mme type (=> de niveau + 2)
        #dans les niveaux de numro suprieur, il faut incrmenter de 1
        #le numro de ces noeuds

        second_cc_num = first.get_cc ()
        second_level = first.get_level () + 1
        
        #on rcupre le prochain number
        second_number = self.get_next_number (second_cc_num,
                                              second_level)
        
        #on met  jour placement dans le noeud
        second.set_placement (second_cc_num,
                              second_level,
                              second_number)
            
        #on ajoute "second"  la fin du niveau dans la cc qui faut
        self._cc[second_cc_num][second_level].append (second)

        #on incrmente les numbers des nodes de mme type
        #dans les niveaux suprieurs
        next_number = second_number + 1
        self.update_numbers (second_cc_num,
                             second_level,
                             next_number)
          

    def nn_third_case (self, first, second):
        print "third case"
        #si le premier noeud est une place, 
        #insertion au niveau 0 de la cc du second noeud
        #number de la place = 0 si c'est la premire (1er niveau
        #peut tre vide, cf CAS N1)
        #sinon = (number du dernier node du niveau 0) + 1

        #si le premier noeud est une transition, 
        #insertion au niveau 1 de la cc du second noeud
        #le niveau 1 possde ncessairement au moins
        #une transition : le number de la transition 
        # ajouter = (number du dernier node du niveau 1) + 1

        #Nouvelle numrotation :
        #SI premier noeud est un place :
        #on incrmente les numbers des places de niveaux suprieurs (2,4 ..)
        #SINON :
        #(le premier noeud est une transition de niveau 1)
          #SI le second noeud est de niveau infrieur (niveau 0)
            #dcaler de 1 le niveau des successeurs
            #(dcalage vers le bas de l'arbre) et modification de la matrice
            #de la composante en consquence
            #on renumrote tous les noeuds de la cc

        #Incrmentation du niveau des successeurs :
        #Il faut travailler sur le graphe priv des
        #arcs retours (cycle)
        
        first_cc_num = second.get_cc ()
        second_cc_num = second.get_cc ()
        second_cc = self._cc[second_cc_num]
        second_level = second.get_level ()
        
        if (type(first) is Place):
            first_level = 0
        else:
            first_level = 1

        print "first level : ",first_level
        print "second level : ",second_level    
        #le premier noeud est une transition (niveau 1),
        #le second noeud une place de niveau 0
        if second_level < first_level:
            print "amont cc"
            start_level = 2
            self.shift_level_down (second, start_level)
            print "cc 2 ", second_cc
            first.set_level (first_level)
            first.set_cc (first_cc_num)
            #insertion du noeud dans la cc de second
            second_cc[first_level].append (first)
            #on renumrote les noeuds de la composante
            self.number_cc (second_cc_num)
            
        else:
            #get_next_number renvoie le prochain numro du niveau
            print "appel get_next_number"
            first_number = self.get_next_number (second_cc_num,
                                                 first_level)
            #modification du placement du noeud
            first.set_placement (first_cc_num, first_level, first_number)

            #insertion du noeud dans la cc de second
            second_cc[first_level].append (first)
            
            #mis  jour de la numrotation
            next_number = first_number + 1
            self.update_numbers (second_cc_num, first_level, next_number)
                        
              
    def animate_all (self):
        for nk in self._nodes.keys():
            node = self._nodes [nk]
            if type(node) is Transition:
                if node.is_validated ():
                    if (len (node.get_successors ())> 0):
                        node.activate ()

    def animate (self, transitions):
        for trans in transitions:
            if trans.is_validated () and (len (trans.get_successors ())> 0):
                trans.activate ()


    ##***** METHODES D'INITIALISATION APPELEES PAR
    ##***** LE CONSTRUCTEUR
    ##Toolbar 
    def get_toolbar (self):
        tb = Graph.get_toolbar (self)
        tb = remove_toolbar_item (tb, 'IN')
        tb = add_toolbar_item (tb, 'IN','add_place.png',
                               self.make_place)
        tb = add_toolbar_item (tb, 'IN','add_trans.png',
                               self.make_trans)
        
        return tb


