#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from Arc import *

class Edge(Arc):

    def __init__(self, graph):
        Arc.__init__(self, graph)
        self.set_directed (False)

    def __del__(self):
        Arc.__del__(self)

    def attach (self, first, second):
        Arc.attach (self, first, second)
        self._first_node.add_in_edge (self)
        self._second_node.add_out_edge (self)

    def delete (self):
        #commencer le travail...
        self._first_node.remove_in_edge (self)
        self._second_node.remove_out_edge (self)
        #...que termine notre parent
        Arc.delete (self)
        
