/* outputs.h

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   See the GNU General Public License at <http://www.gnu.org/licenses/> 

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

*/

#ifndef OUTPUTS_H_DEFINED


/* ----------------------------------------------------------------------------
   Type definitions
*/

#ifndef TRUE
typedef int BOOL;
#define TRUE  1
#define FALSE 0
#endif


/* ----------------------------------------------------------------------------
   Constants
*/

#define MAXFILENAME  100


/* ----------------------------------------------------------------------------
   Prototypes
*/

void CloseOutputs (char *const prefixname);
void CreateFileName (char *const filename, char *const prefixname,
                     char *const suffixname);
void InitOutputs (char *const filename);
void SaveBestGraph (void);
void SaveChain (int to_out);
void SaveDegreeCounts (void);
void SaveEdgeP (FILE * outFile);
void SaveGraph (void);
void SaveMotifsP (FILE * outFile);


/* ----------------------------------------------------------------------------
   Global declarations
*/

// flags to turn on/off outputs and associated computations
BOOL   bsave_the_chain;
BOOL   bsave_best_graph;
BOOL   bsave_the_edge_probabilies;
BOOL   bsave_the_degree_counts;
BOOL   bsave_the_motifs_probabilies;
BOOL   bsave_some_graphs;
int    n_saved_adjacency; // avoid huge numbers!
long   dNextPrint, dPrintStep;

// output files
FILE   *pChainFile;         // binary output file for the chain
FILE   *pEdgeFile;          // text output file for the edge probabilities
FILE   *pDegreeFile;        // text output file for cumulated degree counts
FILE   *pMotifFile;         // text output file for E and F loops counts
FILE   *pGraphsFile;        // text output for random adjancency matrices
FILE   *pBestFile;          // text output for best adjancency matrices

// externals, to be defined elsewhere
extern BOOL   bBN;                 // sample Bayesian networks
extern BOOL   bData;               // flag the availability of data
extern int    **best_adj;          // max probability adjacency matrix sampled
extern int    **current_adj;       // current adjacency matrix
extern double *cumdegree_count;
extern double cum_nEloops;         // cumulated number of Endless loops
extern double cum_nFloops;         // cumulated number of Frustrated loops
extern double current_logprior;
extern double current_loglikelihood;
extern double current_logposterior;
extern double dBestPrior;          // prior of the max posterior graph
extern double dBestLikelihood;     // likelihood of the max posterior graph
extern double dBestPosterior;      // maximum graph probability found in a run
extern long   iter;
extern double **mat_sum;           // cumulated edges counts over graphs
extern long   nBurnin;
extern int    nNodes;              // the number of nodes in graph
extern long   nRuns;


/* End */

#define OUTPUTS_H_DEFINED
#endif  /* OUTPUTS_H_DEFINED */

