/* graph_sampler.h

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   See the GNU General Public License at <http://www.gnu.org/licenses/> 

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

*/

#ifndef GS_H_DEFINED


/* ----------------------------------------------------------------------------
   Inclusions
*/

#include <limits.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "degree.h"
#include "concordance.h"
#include "lexerr.h"
#include "lists.h"
#include "matrices.h"
#include "motifs.h"
#include "outputs.h"
#include "random.h"
#include "topo_sort.h"
#include "y.tab.h"


/* ----------------------------------------------------------------------------
   Macros
*/

#define Readln(_pf) ((fscanf (_pf, "%*[^\n]") < 0) ? -1: fgetc(_pf))


/* ----------------------------------------------------------------------------
   Prototypes
*/
void   AnnounceProgram (void);

void   CleanupMemory (void);

double DLoglikelihood_node (int node, double **pData);

void   GetCmdLineArgs (int cArg, char *const *rgszArg, char **pszFileIn, 
                       char **pszPrefixOut);

double GLoglikelihood_node (int node, double **pData);

void   InitArrays (void);

void   Loglikelihood_diff (int parent, int child, int diff, 
                           double **pData, double *logLdiff);
double Loglikelihood_full (int N, double **pData);
void   Logprior_diff (int **adjacency_current,
                      int parent_node, int child_node, int diff,
                      double *logPdiff);
double Logprior_diff_bernoulli (int parent_node, int child_node, int diff);
double Logprior_full (int N, int **adjacency);

void   ReadScript_Bison (char *const filename);

void   SetPriorHyperParam (void);

void   UpdateBestGraph (void);
void   UpdateEdgeP (void);

double ZLoglikelihood_node (int node, double **pData);


/* ----------------------------------------------------------------------------
   Global declarations, shared
*/

// basic flags and variables
BOOL   autocycle;           // A  -> A edges allowed
BOOL   bBN;                 // sample Bayesian networks
BOOL   bDBN;                // sample dynamic Bayesian networks
int    nNodes;              // the number of nodes in graph
long   seed;

// core computational variables
int    ***adj;              // super set of adjacency matrices for DBNs
int    **current_adj;       // current adjacency matrix
int    diff;
int    parent, child;

// stuff for basic Bernoulli prior
double **hyper_pB;          // hyper parameters of the prior pairwise edges

// stuff for edge concordance prior
BOOL   bPriorConcordance;   // flag for including a concordance prior
int    **edge_requirements; // prior edge pattern matrix
double lambda_concord;      // exponent for concordance weighting

// stuff for prior on degree distribution
BOOL   bPriorDegreeNode;    // flag for including a power prior on degrees
double *cumdegree_count;
int    *current_degrees;    // point to a table of # of edges for each node
double *degree_count;
double gamma_degree;        // exponent of the degrees power prior

// stuff for prior on motifs
BOOL   bPriorMotif;         // flag for including a prior on defined motifs
int    alpha_motif;         // alpha beta-binomial parameter for Eloops P
int    beta_motif;          // second beta-binomial parameter
double cum_nEloops;         // cumulated number of Endless loops
double cum_nFloops;         // cumulated number of Frustrated loops
long   current_nEloops;     // current number of Endless loops
long   current_nFloops;     // current number of Frustrated loops
long   diff_nEloops;        // proposed change in E loops count
long   diff_nFloops;        // proposed change in F loops count
double current_motif_prior; // density of the motif prior in current graph
double proposd_motif_prior; // density of the motif prior in proposed graph


// stuff for priors handling
double current_logprior;
double dBestPrior;          // prior of the max posterior graph 

// stuff for likelihood handling
double current_loglikelihood;
double dBestLikelihood;     // likelihood of the max posterior graph

// stuff for posterior handling
double current_logposterior;
double dBestPosterior;      // maximum graph probability found in a run
int    **best_adj;          // maximum probability adjacency matrix sampled

// stuff for likelihoods
BOOL   bDirichlet;          // Dirichlet score on or off
BOOL   bZellner;            // Zellner score on or off
double gamma_zellner;       // tuning parameter for Zellner score

// stuff for data handling
BOOL   bData;               // flag the availability of data
int    nData;               // number of data points per node in input
double **pData;             // data structure (a vector of data per node)
int    *pDataLevels;        // number of codes per node for discrete data

// computational helps
double **mat_sum;           // cumulated edges counts over graphs
double **pdWorkMatrixSizeN;

// MCMC parameters
long   nRuns, nBurnin;
long   iter;

// default input file name
static char vszFileInDefault[] = "script.txt";

#define GS_H_DEFINED
#endif

/* end */
