/* routes.c

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   See the GNU General Public License at <http://www.gnu.org/licenses/> 

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

   Routes is a DAG checking algorithm, unused in fact.
*/


/* ----------------------------------------------------------------------------
   Inclusions
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "routes.h"
#include "matrices.h"


/* ----------------------------------------------------------------------------
   Globals
*/

int    **routes = NULL;     // route matrix for DAGs
int    **routes_tmp = NULL; // storage for route matrix


/* ----------------------------------------------------------------------------
   ComputeAllRoutes

   Compute a route matrix for an adjacency matrix by repeated calls to 
   RoutesAddEdge.
   The routes matrix element (i,j) is the number of routes from i to j.
*/
void ComputeAllRoutes (int nNodes, int **adjacency, int **routes)
{
  int i, j;

  for (i = 0; i < nNodes; i++) { // for each node
    for (j = 0; j < nNodes; j++) { 
      // for each parent of j
      if (adjacency[i][j]) {
        RoutesAddEdge (nNodes, routes, i, j);
      }
    }
  }

} /* ComputeAllRoutes */


/* ----------------------------------------------------------------------------
   InitRoutes

   Initialize global route matrices.
*/
void InitRoutes (int nNodes)
{
  int i, j;

  if (!routes) {
    routes = InitiMatrix(nNodes, nNodes);      // global!
    routes_tmp = InitiMatrix(nNodes, nNodes);  // global!
  }
  
  for (i = 0; i < nNodes; i++)  // ith line
    for (j = 0; j < nNodes; j++)  // jth column
      routes[i][j] = (i == j ? 1 : 0);

} /* InitRoutes */


/* ----------------------------------------------------------------------------
   IsDAG_w_routes

   Check if a route matrix is that of a DAG (a path A -> B forbids B -> A).
   The diagonal of the adjacency matrix also needs to be checked if you are
   not sure that it is zero. If you are sure, pass NULL for **adjacency, it
   will not be checked.
*/
BOOL IsDAG_w_routes (int nNodes, int **adjacency, int **routes)
{
  int i, j;

  if (adjacency)
    for (i = 0; i < nNodes; i++)
      if (adjacency[i][i])
        return(FALSE);

  for (i = 0; i < nNodes; i++) {
    for (j = 0; j < nNodes; j++) {
      if ((i != j) && routes[i][j] && routes[j][i])
        return (FALSE);
    }
  }
  return (TRUE);
  
} /* IsDAG_w_routes */


/* ----------------------------------------------------------------------------
   RoutesAddEdge

   Recompute a route matrix when an edge from node "parent" to node "child" is
   added.
*/
void RoutesAddEdge (int nNodes, int **routes, int parent, int child)
{
  int i, j;

  for (i = 0; i < nNodes; i++) {
    for (j = 0; j < nNodes; j++) {
      if ((i != j) && routes[child][j] && routes[i][parent]) // avoid zeros
        routes[i][j] = routes[i][j] + routes[child][j] * routes[i][parent];
    }
  }

} /* RoutesAddEdge */


/* ----------------------------------------------------------------------------
   RoutesRemoveEdge

   Recompute a route matrix when an edge from node "parent" to node "child" is
   removed.
*/
void RoutesRemoveEdge (int nNodes, int **routes, long parent, long child)
{
  int i, j;

  for (i = 0; i < nNodes; i++) {
    for (j = 0; j < nNodes; j++) {
      // avoid the zeros
      if ((i != j) && routes[i][j] && routes[child][j] && routes[i][parent])
        routes[i][j] = routes[i][j] - routes[child][j] * routes[i][parent];
    }
  }

} /* RoutesRemoveEdge */


/* end */
