/* -*- c++ -*- (enables emacs c++ mode)                                    */
/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_mesh_fem.C : mesh fem management.                   */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef __MATLABINT_MESH_FEM_H
#define __MATLABINT_MESH_FEM_H

#include <matlabint.h>
#include <matlabint_object.h>
#include <getfem_mesh_fem.h>

namespace matlabint
{

  class matlabint_mesh_fem : public matlabint::getfem_object {
  private:
    mesh_fem_int *mf;
    
  public:
    matlabint_mesh_fem(getfem::getfem_mesh *m, unsigned u_dim) { 
      assert(workspace == 0);
      mf = new mesh_fem_int(*m, u_dim);
    }
    ~matlabint_mesh_fem() {
      delete mf;
    }
    std::string type_name() const { return "mesh_fem"; }
    size_type memsize() const { return mf->memsize(); }
    
    void clear() { mf->clear(); }

    mesh_fem_int& mesh_fem() { return *mf; }
    const mesh_fem_int& mesh_fem() const { return *mf; }
    const getfem::getfem_mesh& linked_mesh() const { return mf->linked_mesh(); }
  };

  inline bool object_is_mesh_fem(getfem_object *o) {
    return (o->type_name().compare("mesh_fem")==0);
  }

  inline matlabint_mesh_fem* object_to_mesh_fem(getfem_object *o) {
    if (object_is_mesh_fem(o)) return ((matlabint_mesh_fem*)o);
    else THROW_INTERNAL_ERROR;
  }
}  /* end of namespace matlabint.                                          */

#endif /* __MATLABINT_MESH_FEM_H                                           */
