/* -*- c++ -*- (enables emacs c++ mode)                                    */
/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_mesh.h : mesh management.                           */
/*     									   */
/*                                                                         */
/* Date : August 2002                                                      */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr,J. Pommier           */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef __MATLABINT_MESH_H
#define __MATLABINT_MESH_H

#include <matlabint_std.h>
#include <matlabint_object.h>
#include <getfem_mesh.h>
#include <getfem_export.h>

namespace matlabint
{
  class matlabint_mesh : public getfem_object {
  private:
    getfem::getfem_mesh *m;

  public:
    matlabint_mesh() { 
      assert(workspace == 0);
      m = new getfem::getfem_mesh();
    }
    ~matlabint_mesh() {
      m->clear();
      delete m;
    }
    std::string type_name() const { return "mesh"; }
    size_type memsize() const { return m->memsize(); }
    getfem::getfem_mesh& mesh() { return *m; }
    const getfem::getfem_mesh& mesh() const { return *m; }
  };

  inline bool object_is_mesh(getfem_object *o) {
    return (o->type_name().compare("mesh") == 0);
  }

  inline matlabint_mesh* object_to_mesh(getfem_object *o) {
    if (object_is_mesh(o)) return ((matlabint_mesh*)o);
    else THROW_INTERNAL_ERROR;
  }
}  /* end of namespace matlabint.                                          */

#endif /* __MATLABINT_MESH_H                                               */
