% FUNCTION [...] = gf_util([operation [, args]])
%
%   Performs various operations which do not fit elsewhere.
%   
%
%   * gf_util('save matrix', string FMT, string FILENAME, mat A)
%   Exports a sparse matrix into the file named FILENAME, using
%   Harwell-Boeing (FMT='hb') or Matrix-Market (FMT='mm') formatting.
%
%   * A = gf_util('load matrix', string FMT, string FILENAME)
%   Imports a sparse matrix from a file.
%
%   * gf_util('trace level', int level)
%   Set the verbosity of some getfem++ routines.
%   
%   Typically the messages printed by the model bricks, 0 means no
%   trace message (default is 3).
%
%   * gf_util('warning level', int level)
%   Filter the less important warnings displayed by getfem.
%   
%   0 means no warnings, default level is 3.
%
%
function [varargout]=gf_util(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('util', varargin{:});
  else
    gf_matlab('util', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
