% FUNCTION [...] = gf_global_function_get(global_function GF, [operation [, args]])
%
%   General function for querying information about global_function objects.
%   
%
%   * VALs = gf_global_function_get(global_function GF, 'val',mat PTs)
%   Return `val` function evaluation in `PTs` (column points).
%
%   * GRADs = gf_global_function_get(global_function GF, 'grad',mat PTs)
%   Return `grad` function evaluation in `PTs` (column points).
%   
%   On return, each column of `GRADs` is of the
%   form [Gx,Gy].
%
%   * HESSs = gf_global_function_get(global_function GF, 'hess',mat PTs)
%   Return `hess` function evaluation in `PTs` (column points).
%   
%   On return, each column of `HESSs` is of the
%   form [Hxx,Hxy,Hyx,Hyy].
%
%   * s = gf_global_function_get(global_function GF, 'char')
%   Output a (unique) string representation of the global_function.
%   
%   This can be used to perform comparisons between two
%   different global_function objects.
%   This function is to be completed.
%   
%
%   * gf_global_function_get(global_function GF, 'display')
%   displays a short summary for a global_function object.
%
%
function [varargout]=gf_global_function_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('global_function_get', varargin{:});
  else
    gf_matlab('global_function_get', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
