% FUNCTION [...] = gf_mesh_fem([operation [, args]])
%
%   General constructor for mesh_fem objects.
%
%   This object represent a finite element method defined on a whole mesh.
%   
%
%   * MF = gf_mesh_fem('load', string fname[, mesh m])
%   Load a mesh_fem from a file.
%   
%   If the mesh `m` is not supplied (this kind of file does not store the
%   mesh), then it is read from the file `fname` and its descriptor is
%   returned as the second output argument.
%
%   * MF = gf_mesh_fem('from string', string s[, mesh m])
%   Create a mesh_fem object from its string description.
%   
%   See also ``gf_mesh_fem_get(mesh_fem MF, 'char')``
%
%   * MF = gf_mesh_fem('clone', mesh_fem mf)
%   Create a copy of a mesh_fem.
%
%   * MF = gf_mesh_fem('sum', mesh_fem mf1, mesh_fem mf2[, mesh_fem mf3[, ...]])
%   Create a mesh_fem that combines two (or more) mesh_fem's.
%   
%   All mesh_fem must share the same mesh (see
%   ``gf_fem('interpolated_fem')`` to map a mesh_fem onto another).
%   
%   After that, you should not modify the FEM of `mf1`, `mf2` etc.
%
%   * MF = gf_mesh_fem('levelset', mesh_levelset mls, mesh_fem mf)
%   Create a mesh_fem that is conformal to implicit surfaces defined in
%   mesh_levelset.
%
%   * MF = gf_mesh_fem('global function', mesh m, levelset ls, {global_function GF1,...}[, int Qdim_m])
%   Create a mesh_fem whose base functions are global function given by the
%   user.
%
%   * MF = gf_mesh_fem('partial', mesh_fem mf, ivec DOFs[, ivec RCVs])
%   Build a restricted mesh_fem by keeping only a subset of the degrees of
%   freedom of `mf`.
%   
%   If `RCVs` is given, no FEM will be put on the convexes listed in
%   `RCVs`.
%
%   * MF = gf_mesh_fem(mesh m[, int Qdim_m=1[, int Qdim_n=1]])
%   Build a new mesh_fem object.
%   
%   `Qdim_m` and `Qdim_n` parameters are optionals. Returns the handle of
%   the created object.
%
%
function [varargout]=gf_mesh_fem(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem', varargin{:});
  else
    gf_matlab('mesh_fem', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
