function [varargout]=subsref(obj, index)
% gfModel/subsref
  nout = max(nargout, 1); cnt=1;
  FGET = @gf_model_get;
  FSET = @gf_model_set;
  switch index(1).type
    case '{}'
      error('Cell array indexing not supported by gfModel objects')
    case '()'
      error('array indexing not supported by gfModel objects')
    case '.'
      switch index(1).subs
        case 'id'
          [varargout{1:nout}] = obj.id;
        case 'clear'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'clear', index(2).subs{:});
          else
            FSET(obj, 'clear', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_fem_variable'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_fem_variable', index(2).subs{:});
          else
            FSET(obj, 'add_fem_variable', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_variable'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_variable', index(2).subs{:});
          else
            FSET(obj, 'add_variable', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'resize_variable'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'resize_variable', index(2).subs{:});
          else
            FSET(obj, 'resize_variable', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_multiplier'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_multiplier', index(2).subs{:});
          else
            FSET(obj, 'add_multiplier', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_fem_data'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_fem_data', index(2).subs{:});
          else
            FSET(obj, 'add_fem_data', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_initialized_fem_data'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_initialized_fem_data', index(2).subs{:});
          else
            FSET(obj, 'add_initialized_fem_data', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_data'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_data', index(2).subs{:});
          else
            FSET(obj, 'add_data', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_initialized_data'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_initialized_data', index(2).subs{:});
          else
            FSET(obj, 'add_initialized_data', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'set_variable'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'variable', index(2).subs{:});
          else
            FSET(obj, 'variable', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'to_variables'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'to_variables', index(2).subs{:});
          else
            FSET(obj, 'to_variables', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_Laplacian_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_Laplacian_brick', index(2).subs{:});
          else
            FSET(obj, 'add_Laplacian_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_generic_elliptic_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_generic_elliptic_brick', index(2).subs{:});
          else
            FSET(obj, 'add_generic_elliptic_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_source_term_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_source_term_brick', index(2).subs{:});
          else
            FSET(obj, 'add_source_term_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_normal_source_term_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_normal_source_term_brick', index(2).subs{:});
          else
            FSET(obj, 'add_normal_source_term_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_Dirichlet_condition_with_multipliers'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_Dirichlet_condition_with_multipliers', index(2).subs{:});
          else
            FSET(obj, 'add_Dirichlet_condition_with_multipliers', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_Dirichlet_condition_with_penalization'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_Dirichlet_condition_with_penalization', index(2).subs{:});
          else
            FSET(obj, 'add_Dirichlet_condition_with_penalization', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_generalized_Dirichlet_condition_with_multipliers'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_generalized_Dirichlet_condition_with_multipliers', index(2).subs{:});
          else
            FSET(obj, 'add_generalized_Dirichlet_condition_with_multipliers', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_generalized_Dirichlet_condition_with_penalization'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_generalized_Dirichlet_condition_with_penalization', index(2).subs{:});
          else
            FSET(obj, 'add_generalized_Dirichlet_condition_with_penalization', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'change_penalization_coeff'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'change_penalization_coeff', index(2).subs{:});
          else
            FSET(obj, 'change_penalization_coeff', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_Helmholtz_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_Helmholtz_brick', index(2).subs{:});
          else
            FSET(obj, 'add_Helmholtz_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_Fourier_Robin_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_Fourier_Robin_brick', index(2).subs{:});
          else
            FSET(obj, 'add_Fourier_Robin_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_constraint_with_multipliers'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_constraint_with_multipliers', index(2).subs{:});
          else
            FSET(obj, 'add_constraint_with_multipliers', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_constraint_with_penalization'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_constraint_with_penalization', index(2).subs{:});
          else
            FSET(obj, 'add_constraint_with_penalization', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_explicit_matrix'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_explicit_matrix', index(2).subs{:});
          else
            FSET(obj, 'add_explicit_matrix', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_explicit_rhs'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_explicit_rhs', index(2).subs{:});
          else
            FSET(obj, 'add_explicit_rhs', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'set_private_matrix'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'set_private_matrix', index(2).subs{:});
          else
            FSET(obj, 'set_private_matrix', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'set_private_rhs'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'set_private_rhs', index(2).subs{:});
          else
            FSET(obj, 'set_private_rhs', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_isotropic_linearized_elasticity_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_isotropic_linearized_elasticity_brick', index(2).subs{:});
          else
            FSET(obj, 'add_isotropic_linearized_elasticity_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_linear_incompressibility_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_linear_incompressibility_brick', index(2).subs{:});
          else
            FSET(obj, 'add_linear_incompressibility_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_nonlinear_elasticity_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_nonlinear_elasticity_brick', index(2).subs{:});
          else
            FSET(obj, 'add_nonlinear_elasticity_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_nonlinear_incompressibility_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_nonlinear_incompressibility_brick', index(2).subs{:});
          else
            FSET(obj, 'add_nonlinear_incompressibility_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_mass_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_mass_brick', index(2).subs{:});
          else
            FSET(obj, 'add_mass_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_basic_d_on_dt_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_basic_d_on_dt_brick', index(2).subs{:});
          else
            FSET(obj, 'add_basic_d_on_dt_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_basic_d2_on_dt2_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_basic_d2_on_dt2_brick', index(2).subs{:});
          else
            FSET(obj, 'add_basic_d2_on_dt2_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_theta_method_dispatcher'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_theta_method_dispatcher', index(2).subs{:});
          else
            FSET(obj, 'add_theta_method_dispatcher', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_midpoint_dispatcher'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_midpoint_dispatcher', index(2).subs{:});
          else
            FSET(obj, 'add_midpoint_dispatcher', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'velocity_update_for_order_two_theta_method'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'velocity_update_for_order_two_theta_method', index(2).subs{:});
          else
            FSET(obj, 'velocity_update_for_order_two_theta_method', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'velocity_update_for_Newmark_scheme'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'velocity_update_for_Newmark_scheme', index(2).subs{:});
          else
            FSET(obj, 'velocity_update_for_Newmark_scheme', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'disable_bricks'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'disable_bricks', index(2).subs{:});
          else
            FSET(obj, 'disable_bricks', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'unable_bricks'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'unable_bricks', index(2).subs{:});
          else
            FSET(obj, 'unable_bricks', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'first_iter'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'first_iter', index(2).subs{:});
          else
            FSET(obj, 'first_iter', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'next_iter'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'next_iter', index(2).subs{:});
          else
            FSET(obj, 'next_iter', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_basic_contact_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_basic_contact_brick', index(2).subs{:});
          else
            FSET(obj, 'add_basic_contact_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'contact_brick_set_BN'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'contact_brick_set_BN', index(2).subs{:});
          else
            FSET(obj, 'contact_brick_set_BN', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'contact_brick_set_BT'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'contact_brick_set_BT', index(2).subs{:});
          else
            FSET(obj, 'contact_brick_set_BT', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_contact_with_rigid_obstacle_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_contact_with_rigid_obstacle_brick', index(2).subs{:});
          else
            FSET(obj, 'add_contact_with_rigid_obstacle_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'add_unilateral_contact_brick'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'add_unilateral_contact_brick', index(2).subs{:});
          else
            FSET(obj, 'add_unilateral_contact_brick', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'set'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, index(2).subs{:});
          else
            FSET(obj,index(2).subs{:});
            if (exist('ans', 'var') == 1)
              h=ans;
              if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
              varargout{1}=h;
            end;
          end;
          return;
        case 'get'
          if (nargout) 
            h = FGET(obj, index(2).subs{:});
            if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
            [varargout{1:nargout}] = h;
          else
	     FGET(obj,index(2).subs{:});
            if (exist('ans', 'var') == 1)
              h=ans;
              if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
              varargout{1}=h;
            end;
          end;
          return;
        otherwise
          if ((numel(index) > 1) && (strcmp(index(2).type, '()')))
            h = FGET(obj,index(1).subs, index(2).subs{:});
            if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
            [varargout{1:nargout}] = h;
            cnt = cnt + 1;
          else
            h = FGET(obj, index(1).subs);
            if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
            [varargout{1:nargout}] = h;
          end
      end
  end
  % if there are others indexes, let matlab do its work
  if (numel(index) > cnt)
    for i=1:nout,
      varargout{i} = subsref(varargout{i}, index((cnt+1):end));
    end;
  end;
% autogenerated mfile;
