% FUNCTION [x] = gf_mesh_fem_get(meshfem MF, operation [, args])
% 
%   General function for inquiry about mesh_fem objects.
% 
%   * I = gf_mesh_fem_get(MF,'nbdof')
%   Return the number of Degrees of Freedom (DoF) of the meshfem MF.
% 
%   * I = gf_mesh_fem_get(MF,'dof_from_cv,' CVLST)
%   Return the DoF of the convexes listed in CVLST.   WARNING: the Degree of
%   Freedom might be returned in ANY order, do not use this function in your
%   assembly routines. Use 'dof from cvid' instead, if you want to be able to map
%   a convex number with its associated degrees of freedom.  One can also get the
%   list of dof on a set on convex faces, by indicating on the second row of CVLST
%   the faces numbers (with respect to the convex number on the first row).
% 
%   *  [DOFS,IDX]=gf_mesh_fem_get(MF,'dof_from_cvid'[,CVLST])
%   Return the degrees of freedom attached to each convex of the mesh.\\\\  If
%   CVLST is omitted, all the convexes will be considered (equivalent to CVLST = 1
%   ... @gf_mesh_get(M,'max_cvid')).  IDX is a row vector, length(IDX) =
%   length(CVLIST)+1. DOFS is a row vector containing the concatenated list of dof
%   of each convex in CVLST. Each entry of IDX is the position of the
%   corresponding convex point list in DOFS. Hence, for example, the list of
%   points of the second convex is DOFS(IDX(2):IDX(3)-1).\\  If CVLST contains
%   convex #id which do not exist in the mesh, their point list will be empty.
% 
%   * gf_mesh_fem_get(MF,'non_conformal_dof'[,CVLST])
%   Return partially linked degrees of freedom.  Return the dof located on the
%   border of a convex and which belong to only one convex, except the ones which
%   are located on the border of the mesh.  For example, if the convex 'a' and 'b'
%   share a common face, 'a' has a P1 FEM, and 'b' has a P2 FEM, then the dof on
%   the middle of the face will be returned by this function (this can be useful
%   when searching the interfaces between classical FEM and hierarchical FEM).
% 
%   * gf_mesh_fem_get(MF,'qdim')
%   Return the dimension Q of the field interpolated by the mesh_fem.  By default,
%   Q=1 (scalar field). This has an impact on the DOF numbering.
% 
%   * [FEMLST, CV2F] = gf_mesh_fem_get(MF,'fem'[, CVLST])
%   Return a list of FEM used by the meshfem.   FEMLST is an array of all @tfem
%   objects found in the convexes given in CVLST. If CV2F was supplied as an
%   output argument, it contains, for each convex listed in CVLST, the index of
%   its correspounding FEM in FEMLST.
% 
%   Example:
%      cvid=gf_mesh_get(mf,'cvid');
%      [f,c2f]=gf_mesh_fem_get(mf, 'fem');
%      for i=1:size(f), sf{i}=gf_fem_get('char',f(i)); end;
%      for i=1:size(c2f),
%        disp(sprintf('the fem of convex %d is %s',...
%             cvid(i),sf{i}));
%      end;
%   * I = gf_mesh_fem_get(MF,'is_lagrangian'[,CVLST])
%   Test if the meshfem is Lagrangian.  Lagrangian means that each base function
%   Phi[i] is such that
%       Phi[i](P[j]) = delta(i,j),
%    where P[j] is the DoF location of the jth base function, and delta(i,j) = 1
%   if i==j, else 0.
%     If CVLST is omitted, it returns 1 if all convexes in the mesh are
%   Lagrangian. If CVLST is used, it returns the convex indices (with respect to
%   CVLST) which are Lagrangian.
% 
%   * I = gf_mesh_fem_get(MF,'is_equivalent'[,CVLST])
%   Test if the meshfem is equivalent.  See gf_mesh_fem_get(MF,'is_lagrangian')
% 
%   * I = gf_mesh_fem_get(MF,'is_polynomial'[,CVLST])
%   Test if all base functions are polynomials.  See
%   gf_mesh_fem_get(MF,'is_lagrangian')
% 
%   * DOFLST = gf_mesh_fem_get(MF,'dof_on_region,' RLIST)
%   Return the list of dof lying on one of the mesh regions listed in RLIST.  More
%   precisely, this function returns the DoF whose support is non-null on one of
%   regions whose #ids are listed in RLIST (note that for boundary regions, some
%   dof nodes may not lie exactly on the boundary, for example the dof of PK(n,0)
%   lies on the center of the convex, but the base function in not null on the
%   convex border).
% 
%   * [DOF_XY] = gf_mesh_fem_get(MF,'dof_nodes'[, DOFLST])
%   Get location of Degrees of Freedom.  Return the list of interpolation points
%   for the specified dof #IDs in DOFLST (if DOFLST is omitted, all DoF are
%   considered).
% 
%   * U=gf_mesh_fem_get(MF,'interpolate_convex_data,' Ucv)
%    Interpolate data given on each convex of the mesh to the meshfem dof.  The
%   meshfem has to be lagrangian, and should be discontinuous (typically a
%   FEM_PK(N,0) or FEM_QK(N,0) should be used).  The last dimension of the input
%   vector Ucv should have gf_mesh_get(M,'max_cvid') elements.  Example of use:
%   gf_mesh_fem_get(MF,'interpolate_convex_data,' gf_mesh_get(M,'quality'))
% 
%   * gf_mesh_fem_get(MF,'save,' filename [,'with mesh'])
%   Save a meshfem in a text file (and optionaly its linked mesh object).
% 
%   * gf_mesh_fem_get(MF,'char'[,'with mesh'])
%   Output a string description of the mesh_fem.   By default, it does not include
%   the description of the linked mesh object.
% 
%   * gf_mesh_fem_get(MF,'export_to_vtk,' string FILENAME, ... ['ascii'], U,
%   'name'...)
%   Export a mesh_fem and some fields to a vtk file.  The FEM and geometric
%   transformations will be mapped to order 1 or 2 isoparametric PK (or QK) FEMs
%   (as VTK does not handle higher order elements). If you need to represent high-
%   order FEMs or high-order geometric transformations, you should consider
%   @gf_slice_get(SL,'export_to_vtk').
% 
%   * gf_mesh_fem_get(MF,'export_to_dx,' string FILENAME, ... ['as', string
%   mesh_name][,'edges']['serie',string serie_name][,'ascii'][,'append'], U,
%   'name'...)
%   Export a mesh_fem and some fields to an OpenDX file.  This function will fail
%   if the mesh_fem mixes different convex types (i.e. quads and triangles), or if
%   OpenDX does not handle a specific element type (i.e. prism connections are not
%   known by OpenDX).  The FEM will be mapped to order 1 PK (or QK) FEMs. If you
%   need to represent high-order FEMs or high-order geometric transformations, you
%   should consider @gf_slice_get(SL,'export_to_dx').
% 
%   * M=gf_mesh_fem_get(MF,'linked_mesh')
%   Return a reference to the mesh object linked to MF.
% 
%   * gf_mesh_fem_get(MF,'memsize')
%   Return the amount of memory (in bytes) used by the mesh_fem object.  The
%   result does not take into account the linked mesh object.
% 
% 
%   * U=MESHFEM:GET('eval', expr [,DOFLST])
% 
%   Call gf_mesh_fem_get_eval. This function interpolates an expression on a
%   lagrangian mesh_fem (for all dof except if DOFLST is specified). The expression can be a
%   numeric constant, or a cell array containing numeric constants, string
%   expressions or function handles. For example:
%     U1=gf_mesh_fem_get(mf,'eval',1)
%     U2=gf_mesh_fem_get(mf,'eval',[1;0]) % output has two rows
%     U3=gf_mesh_fem_get(mf,'eval',[1 0]) % output has one row, only valid if qdim(mf)==2
%     U4=gf_mesh_fem_get(mf,'eval',{'x';'y.*z';4;@myfunctionofxyz})
% 
%   $Id: gf_mesh_fem_get.cc 2322 2006-03-31 12:21:16Z pommier $
function [varargout]=gf_mesh_fem_get(varargin)
  if (nargin>=2 & strcmpi(varargin{2},'eval')),
    [varargout{1:nargout}]=gf_mesh_fem_get_eval(varargin{[1 3:nargin]}); return;
  end;
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem_get',varargin{:});
  else
    gf_matlab('mesh_fem_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
