/*
  Copyright (C) 2008 Ben Asselstine
  Written by Ben Asselstine

  This file is part of fileschanged.

  fileschanged is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  fileschanged is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with fileschanged; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301  USA
*/
#ifndef FILESCHANGED_LIST_H
#define FILESCHANGED_LIST_H
#include "node.h"
struct list_t
{
	unsigned int count;
	struct node_t *list;
};
int list_init(void **list);
int list_add(void *list, struct node_t *node);
int list_get_element(void *list, unsigned int element, struct node_t **node);
int list_find(void *list, struct node_t *node, struct node_t **found);
void list_count(void *list, unsigned int *count);
void list_show(void *list);
void list_sort(void *list);
void list_free(void *list);
int list_remove_element(void *list, unsigned int element);
#endif
