/*
  Copyright (C) 2008 Ben Asselstine
  Written by Ben Asselstine

  This file is part of fileschanged.

  fileschanged is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  fileschanged is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with fileschanged; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301  USA
*/
#ifndef FILESCHANGED_NODE_H
#define FILESCHANGED_NODE_H
#include <fam.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
struct node_t
{
	struct stat statbuf;
	char *filename;
	FAMRequest request;
	FAMEvent lastevent;
	time_t lastevent_time;
	unsigned int id;
};
void node_free(struct node_t *node);
int node_copy(struct node_t *dst, struct node_t *src);
int node_new(struct node_t *node, char *filename, int deref_symlinks);
int node_compare(struct node_t *n1, struct node_t *n2);
int node_is_empty(struct node_t *node);
#endif
