#include <stdio.h>
#include <stdlib.h>
#include <fam.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <sys/select.h>
#define __USE_GNU
#include <search.h>
#include <libgen.h>
#include <dirent.h>
#include "avl.h"
#include "package.h"
#include "config.h"
#define WHITESPACE " \f\n\r\t\v"
#define TIME_LIMIT 1	//max seconds I'll spend getting messages from fam before I go back to the main select.
#define SECONDS_UNCHANGED 1 //when a file hasn't changed for this many seconds, I'll consider the previous changes to be finished, and I'll print the filename out to stdout.
#define WL_MAX 32768 //max number of files being written to concurrently.
struct arguments {
	int arraylen;
#ifdef ARG_MAX
	char *args[ARG_MAX];
#else
	char **args;
#endif
	int recursive;
	int showdeleted;
	int showchanged;
	int showcreated;
	int showexecuting;
	int showfinishedexecuting;
	int filelist;
	int filestomonitor;
	int hashisnotcomment;
	int filechangetimeout;
	int onefilesystem;
	int showaction;
};
typedef struct
{
	struct stat statbuf;
	char *filename;
	FAMRequest r;
	avl_tree *filetree;
}filenode_type;

const char *argp_program_version = PKG_NAME " " PKG_VERSION "\n" PKG_WEBSITE;
const char *argp_program_bug_address = "<" PKG_BUGREPORT ">";
static char doc[] = "Show altered files (not directories) from the list of filenames given in FILE.  The standard input can be used if FILE is - or absent from the command line.  \tFiles and directories must already exist before they are specified, or they \twill not be monitored.";
static char args_doc[] = "[FILE]...";
const char recursive_option_explanation[]="Monitor subdirectories of directories";
const char showchanged_option_explanation[]="(Default) Show changed files";
const char showcreated_option_explanation[]="(Default) Show newly created files";
const char showexecuting_option_explanation[]="Show executing files";
const char showfinishedexecuting_option_explanation[]="Show files that have stopped executing";
const char showdeleted_option_explanation[]="Show deleted files";
const char filestomonitor_option_explanation[]="Monitor the list of files on the command line";
const char filelist_option_explanation[]="(Default) Monitor the list of filenames in FILE";
const char hashisnotcomment_option_explanation[]="Don't ignore lines in FILE starting with '#'";
const char filechangetimeout_option_explanation[]="Assume changed after N secs of no writes. (Def=2)";
const char onefilesystem_option_explanation[]="Don't monitor files on other filesystems";
const char showaction_option_explanation[]="Report action when reporting altered files";

/* function prototypes */
void sigHandler ();
int compare_nodes();
void cancel_monitoring();
int receive_fam_notifications();
void monitor_file();
void getopt_usage();
void node_free();
