# fileschanged.spec
#
# Copyright (c) 2002 Ben Asselstine benasselstine@users.sourceforge.net
#
%define name fileschanged
%define version 0.5.2

%define release 1
%define manifest %{_builddir}/%{name}-%{version}-%{release}.manifest

# required items
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Utilities/File

# optional items
#Vendor: Ben Asselstine
#Distribution:
#Icon:
#URL:
#Packager: Ben Asselstine benasselstine@users.sourceforge.net

# source + patches
Source: %{name}-%{version}.tar.gz
#Source1:
#Patch:
#Patch1:

# RPM info
#Provides:
#Requires:
#Conflicts:
#Prereq:

#Prefix: /usr
BuildRoot: /var/tmp/%{name}-%{version}

Summary: displays altered files

%description
displays altered files
fileschanged.spec.  Generated from fileschanged.spec.in by configure.
Please edit fileschanged.spec.in to add several more lines of description
here if appropriate, and to delete these instructions.

%prep
%setup -q
#%patch0 -p1

%build
%configure
make

%install
make install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
%makeinstall

# __os_install_post is implicitly expanded after the
# %install section... do it now, and then disable it,
# so all work is done before building manifest.

%{?__os_install_post}
%define __os_install_post %{nil}

# build the file list automagically into %{manifest}

cd $RPM_BUILD_ROOT
rm -f %{manifest}
find . -type d | grep "/%{name}" \
        | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' >> %{manifest}
find . -type f \
        | sed 's,^\.,\%attr(-\,root\,root) ,' >> %{manifest}
find . -type l \
        | sed 's,^\.,\%attr(-\,root\,root) ,' >> %{manifest}
#cp -f %{manifest} /var/tmp
#%pre
#%post
#%preun
#%postun

%clean
rm -f %{manifest}
rm -rf $RPM_BUILD_ROOT

%files -f %{manifest}
%defattr(-,root,root)
#%doc README
#%docdir
#%config

%changelog
* Thu Feb 8 2003 Ben Asselstine <benasselstine@users.sourceforge.net>
- version 0.5.2
- fixed -d option so that it works.

* Thu Oct 10 2002 Ben Asselstine <benasselstine@users.sourceforge.net>
- version 0.5.1
- added --show-action option.

* Thu Sep 26 2002 Ben Asselstine <benasselstine@users.sourceforge.net>
- version 0.5.0
- correctly handling termination of fam server.
- added help2man to missing and configure scripts.
- automatically creating manpage from ./fileschanged --help .
- ran autoproject to fancify things.
- created texinfo page.

* Wed Sep 26 2002 Ben Asselstine <benasselstine@users.sourceforge.net>
- version 0.4.0
- fixed leaks/race conditions to allow for monitoring larger 
- filesets.
- added new option -x to stay on current filesystem (as 
- current working dir).
- built rpm from simple spec file.

* Thu Aug  8 2002 Ben Asselstine <benasselstine@users.sourceforge.net>
- new in version 0.3.0
- created a man page.
- added extra info in --help.
- now checking malloc return values.
- added handy new timeout command line option.

* Sun Jul 14 2002 Ben Asselstine <benasselstine@users.sourceforge.net>
- new in version 0.2.0
- revamped the command-line options to make more sense.
- added feature to see files that start and stop executing.
- changed -d option not report deleted files on stderr.
- fixed getopt crashing
- added some initial error checking.

* Fri Jun  7 2002 Ben Asselstine <benasselstine@users.sourceforge.net>
- initial version
