# You need RubyUnit and MS Excel and MSI to run this test script 

require 'rubyunit'

require 'win32ole'

class TestOLEPARAM < RUNIT::TestCase
  EXCEL_TYPELIB = 'Microsoft Excel 9.0 Object Library'
  XML_TYPELIB = 'Microsoft XML, version 2.0'
  def test_name
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    sh = classes.find {|c| c.name == 'Worksheet'}
    saveas = sh.ole_methods.find {|m| m.name == 'SaveAs'}
    param_names = saveas.params.collect{|p| p.name}
    assert(param_names.size > 0)
    assert(param_names.include?('Filename'))
  end
  def test_ole_type
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    methods = classes.find {|c| c.name == 'Worksheet'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert_equal('BSTR', f.params[0].ole_type)
    methods = classes.find {|c| c.name == 'Workbook'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert_equal('XlSaveAsAccessMode', f.params[6].ole_type)
  end
  def test_ole_type_detail
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    methods = classes.find {|c| c.name == 'Worksheet'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert_equal(['BSTR'], f.params[0].ole_type_detail)
    methods = classes.find {|c| c.name == 'Workbook'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert_equal(['USERDEFINED', 'XlSaveAsAccessMode'], f.params[6].ole_type_detail)
  end
  def test_input
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    methods = classes.find {|c| c.name == 'Worksheet'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert(f.params[0].input?)
  end
  
  def test_output
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    methods = classes.find {|c| c.name == 'Worksheet'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert(!f.params[0].output?)
  end
  def test_optional
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    methods = classes.find {|c| c.name == 'Worksheet'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert(!f.params[0].optional?)
    methods = classes.find {|c| c.name == 'Workbook'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert(f.params[0].optional?)
  end
  def test_ole_type_detail
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    methods = classes.find {|c| c.name == 'Worksheet'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert_equal(nil, f.params[0].default)
    methods = classes.find {|c| c.name == 'Workbook'}.ole_methods
    f = methods.find {|m| m.name == 'SaveAs'}
    assert_equal(1, f.params[6].default)
  end
end
