###################################
#
# vractivex.rb
# Programmed by  nyasu <nyasu@osk.3web.ne.jp>
# Copyright 2003 Nishikawa,Yasuhiro
#
# More information at http://www.threeweb.ad.jp/~nyasu/software/vrproject.html
# (in Japanese)
#
###################################

require 'vr/vruby'
require 'Win32API'
require 'win32ole'

class VRActiveXControl < VRControl
  Win32API.new("atl.dll","AtlAxWinInit","","I").call
  AtlAxGetControl = Win32API.new("atl.dll","AtlAxGetControl","IP","I")

  WINCLASSINFO=["AtlAxWin",0]
  ACTIVEXCINFO=["",""] # PROGID,EVENTSINK

  alias :progId :caption
  alias :progId= :caption=
  def caption() "" end
  def caption=(arg) arg end

  def initialize
    self.progId = self.type::ACTIVEXCINFO[0]
    class <<self
      undef_method :progId=
    end
  end

  def vrinit
    super
    p=[0].pack("I")
    AtlAxGetControl.call(self.hWnd,p)
    p_iunknown = p.unpack("I")[0]
    @_vr_win32ole=nil
    @_vr_win32ole = SWin::Application.iunknown_to_win32ole(p_iunknown)

    if self.type::ACTIVEXCINFO[1] then
      @_vr_win32ole_event = 
        WIN32OLE_EVENT.new(@_vr_win32ole,self.type::ACTIVEXCINFO[1])
    end
  end

  def ole_interface() @_vr_win32ole; end
  def ole_events() @_vr_win32ole_event; end

  def add_oleeventhandler(evname,handlername=evname.downcase)
    ole_events.on_event(evname) do |*args|
      @parent.controlmsg_dispatching(self,handlername,*args)
    end
  end

  def _invoke(*args) @_vr_win32ole._invoke(*args) end
  def _setproperty(*args) @_vr_win32ole._setproperty(*args) end
  def _getproperty(*args) @_vr_win32ole._getproperty(*args) end

end
